/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.NamingConventions;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.ui.CodeGeneration;

public class GetterSetterUtil {
    private static final String[] EMPTY = new String[0];

    private GetterSetterUtil() {
    }

    public static String getGetterName(IField field, String[] excludedNames) throws JavaScriptModelException {
        boolean useIs = StubUtility.useIsForBooleanGetters(field.getJavaScriptProject());
        return GetterSetterUtil.getGetterName(field, excludedNames, useIs);
    }

    private static String getGetterName(IField field, String[] excludedNames, boolean useIsForBoolGetters) throws JavaScriptModelException {
        if (excludedNames == null) {
            excludedNames = EMPTY;
        }
        return GetterSetterUtil.getGetterName(field.getJavaScriptProject(), field.getElementName(), field.getFlags(), useIsForBoolGetters && JavaModelUtil.isBoolean(field), excludedNames);
    }

    public static String getGetterName(IVariableBinding variableType, IJavaScriptProject project, String[] excludedNames, boolean isBoolean) {
        boolean useIs = StubUtility.useIsForBooleanGetters(project) && isBoolean;
        return GetterSetterUtil.getGetterName(project, variableType.getName(), variableType.getModifiers(), useIs, excludedNames);
    }

    public static String getGetterName(IJavaScriptProject project, String fieldName, int flags, boolean isBoolean, String[] excludedNames) {
        return NamingConventions.suggestGetterName(project, fieldName, flags, isBoolean, excludedNames);
    }

    public static String getSetterName(IVariableBinding variableType, IJavaScriptProject project, String[] excludedNames, boolean isBoolean) {
        return GetterSetterUtil.getSetterName(project, variableType.getName(), variableType.getModifiers(), isBoolean, excludedNames);
    }

    public static String getSetterName(IJavaScriptProject project, String fieldName, int flags, boolean isBoolean, String[] excludedNames) {
        return NamingConventions.suggestSetterName(project, fieldName, flags, isBoolean, excludedNames);
    }

    public static String getSetterName(IField field, String[] excludedNames) throws JavaScriptModelException {
        if (excludedNames == null) {
            excludedNames = EMPTY;
        }
        return NamingConventions.suggestSetterName(field.getJavaScriptProject(), field.getElementName(), field.getFlags(), JavaModelUtil.isBoolean(field), excludedNames);
    }

    public static IFunction getGetter(IField field) throws JavaScriptModelException {
        if (field.getDeclaringType() == null) {
            return null;
        }
        String getterName = GetterSetterUtil.getGetterName(field, EMPTY, true);
        IFunction primaryCandidate = JavaModelUtil.findMethod(getterName, new String[0], false, field.getDeclaringType());
        if (!JavaModelUtil.isBoolean(field) || primaryCandidate != null && primaryCandidate.exists()) {
            return primaryCandidate;
        }
        String secondCandidateName = GetterSetterUtil.getGetterName(field, EMPTY, false);
        return JavaModelUtil.findMethod(secondCandidateName, new String[0], false, field.getDeclaringType());
    }

    public static IFunction getSetter(IField field) throws JavaScriptModelException {
        if (field.getDeclaringType() == null) {
            return null;
        }
        String[] args = new String[]{field.getTypeSignature()};
        return JavaModelUtil.findMethod(GetterSetterUtil.getSetterName(field, EMPTY), args, false, field.getDeclaringType());
    }

    public static String getSetterStub(IField field, String setterName, boolean addComments, int flags) throws CoreException {
        String body;
        String comment;
        String fieldName = field.getElementName();
        IType parentType = field.getDeclaringType();
        String returnSig = field.getTypeSignature();
        String typeName = Signature.toString(returnSig);
        IJavaScriptProject project = field.getJavaScriptProject();
        String accessorName = NamingConventions.removePrefixAndSuffixForFieldName(project, fieldName, field.getFlags());
        String argname = StubUtility.suggestArgumentName(project, accessorName, EMPTY);
        boolean isStatic = Flags.isStatic(flags);
        String lineDelim = "\n";
        StringBuffer buf = new StringBuffer();
        if (addComments && (comment = CodeGeneration.getSetterComment(field.getJavaScriptUnit(), parentType.getTypeQualifiedName('.'), setterName, field.getElementName(), typeName, argname, accessorName, lineDelim)) != null) {
            buf.append(comment);
            buf.append(lineDelim);
        }
        buf.append(JdtFlags.getVisibilityString(flags));
        buf.append(' ');
        if (isStatic) {
            buf.append("static ");
        }
        buf.append("void ");
        buf.append(setterName);
        buf.append('(');
        buf.append(typeName);
        buf.append(' ');
        buf.append(argname);
        buf.append(") {");
        buf.append(lineDelim);
        boolean useThis = StubUtility.useThisForFieldAccess(project);
        if (argname.equals(fieldName) || useThis && !isStatic) {
            fieldName = isStatic ? String.valueOf(parentType.getElementName()) + '.' + fieldName : "this." + fieldName;
        }
        if ((body = CodeGeneration.getSetterMethodBodyContent(field.getJavaScriptUnit(), parentType.getTypeQualifiedName('.'), setterName, fieldName, argname, lineDelim)) != null) {
            buf.append(body);
        }
        buf.append("}");
        buf.append(lineDelim);
        return buf.toString();
    }

    public static String getGetterStub(IField field, String getterName, boolean addComments, int flags) throws CoreException {
        String body;
        String comment;
        String fieldName = field.getElementName();
        IType parentType = field.getDeclaringType();
        boolean isStatic = Flags.isStatic(flags);
        String typeName = Signature.toString(field.getTypeSignature());
        String accessorName = NamingConventions.removePrefixAndSuffixForFieldName(field.getJavaScriptProject(), fieldName, field.getFlags());
        String lineDelim = "\n";
        StringBuffer buf = new StringBuffer();
        if (addComments && (comment = CodeGeneration.getGetterComment(field.getJavaScriptUnit(), parentType.getTypeQualifiedName('.'), getterName, field.getElementName(), typeName, accessorName, lineDelim)) != null) {
            buf.append(comment);
            buf.append(lineDelim);
        }
        buf.append(JdtFlags.getVisibilityString(flags));
        buf.append(' ');
        if (isStatic) {
            buf.append("static ");
        }
        buf.append(typeName);
        buf.append(' ');
        buf.append(getterName);
        buf.append("() {");
        buf.append(lineDelim);
        boolean useThis = StubUtility.useThisForFieldAccess(field.getJavaScriptProject());
        if (useThis && !isStatic) {
            fieldName = "this." + fieldName;
        }
        if ((body = CodeGeneration.getGetterMethodBodyContent(field.getJavaScriptUnit(), parentType.getTypeQualifiedName('.'), getterName, fieldName, lineDelim)) != null) {
            buf.append(body);
        }
        buf.append("}");
        buf.append(lineDelim);
        return buf.toString();
    }
}

