/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

public final class AddCustomConstructorOperation
implements IWorkspaceRunnable {
    private boolean fApply = true;
    private final IFunctionBinding fBinding;
    private final IVariableBinding[] fBindings;
    private final List fCreated = new ArrayList();
    private TextEdit fEdit = null;
    private final IJavaScriptElement fInsert;
    private boolean fOmitSuper = false;
    private final boolean fSave;
    private final CodeGenerationSettings fSettings;
    private final IType fType;
    private final JavaScriptUnit fUnit;
    private int fVisibility = 0;

    public AddCustomConstructorOperation(IType type, IJavaScriptElement insert, JavaScriptUnit unit, IVariableBinding[] bindings, IFunctionBinding binding, CodeGenerationSettings settings, boolean apply, boolean save) {
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)bindings);
        Assert.isNotNull((Object)settings);
        this.fType = type;
        this.fInsert = insert;
        this.fUnit = unit;
        this.fBindings = bindings;
        this.fBinding = binding;
        this.fSettings = settings;
        this.fSave = save;
        this.fApply = apply;
    }

    public final TextEdit getResultingEdit() {
        return this.fEdit;
    }

    public final ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public final int getVisibility() {
        return this.fVisibility;
    }

    public final boolean isOmitSuper() {
        return this.fOmitSuper;
    }

    public final void run(IProgressMonitor monitor) throws CoreException {
        block25: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                monitor.beginTask("", 1);
                monitor.setTaskName(CodeGenerationMessages.AddCustomConstructorOperation_description);
                this.fCreated.clear();
                IJavaScriptUnit unit = this.fType.getJavaScriptUnit();
                CompilationUnitRewrite rewrite = new CompilationUnitRewrite(unit, this.fUnit);
                ITypeBinding binding = null;
                ListRewrite rewriter = null;
                if (this.fType.isAnonymous()) {
                    ClassInstanceCreation creation = (ClassInstanceCreation)ASTNodes.getParent(NodeFinder.perform(rewrite.getRoot(), this.fType.getNameRange()), ClassInstanceCreation.class);
                    if (creation != null) {
                        binding = creation.resolveTypeBinding();
                        AnonymousClassDeclaration declaration = creation.getAnonymousClassDeclaration();
                        if (declaration != null) {
                            rewriter = rewrite.getASTRewrite().getListRewrite(declaration, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
                        }
                    }
                } else {
                    AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.getParent(NodeFinder.perform(rewrite.getRoot(), this.fType.getNameRange()), AbstractTypeDeclaration.class);
                    if (declaration != null) {
                        binding = declaration.resolveBinding();
                        rewriter = rewrite.getASTRewrite().getListRewrite(declaration, declaration.getBodyDeclarationsProperty());
                    }
                }
                if (binding == null || rewriter == null) break block25;
                ITextFileBuffer buffer = null;
                IDocument document = null;
                try {
                    CompilationUnitChange change;
                    TextEdit edit;
                    CompilationUnitChange result;
                    FunctionDeclaration stub;
                    if (!JavaModelUtil.isPrimary(unit)) {
                        document = new Document(unit.getBuffer().getContents());
                    } else {
                        buffer = RefactoringFileBuffers.acquire(unit);
                        document = buffer.getDocument();
                    }
                    ASTNode insertion = null;
                    if (this.fInsert instanceof IFunction) {
                        insertion = ASTNodes.getParent(NodeFinder.perform(rewrite.getRoot(), ((IFunction)this.fInsert).getNameRange()), FunctionDeclaration.class);
                    }
                    if ((stub = StubUtility2.createConstructorStub(rewrite.getCu(), rewrite.getASTRewrite(), rewrite.getImportRewrite(), binding, rewrite.getAST(), this.fOmitSuper ? null : this.fBinding, this.fBindings, this.fVisibility, this.fSettings)) != null) {
                        this.fCreated.addAll(Arrays.asList(this.fBindings));
                        if (insertion != null) {
                            rewriter.insertBefore(stub, insertion, null);
                        } else {
                            rewriter.insertLast(stub, null);
                        }
                    }
                    if (!((result = rewrite.createChange()) instanceof CompilationUnitChange) || (edit = (change = result).getEdit()) == null) break block25;
                    try {
                        this.fEdit = edit;
                        if (this.fApply) {
                            edit.apply(document, 2);
                        }
                        if (this.fSave) {
                            if (buffer != null) {
                                buffer.commit((IProgressMonitor)new SubProgressMonitor(monitor, 1), true);
                            } else {
                                unit.getBuffer().setContents(document.get());
                            }
                        }
                    }
                    catch (Exception exception) {
                        throw new CoreException((IStatus)new Status(4, JavaScriptPlugin.getPluginId(), 0, exception.getLocalizedMessage(), (Throwable)exception));
                    }
                }
                finally {
                    if (buffer != null) {
                        RefactoringFileBuffers.release(unit);
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    public final void setOmitSuper(boolean omit) {
        this.fOmitSuper = omit;
    }

    public final void setVisibility(int visibility) {
        this.fVisibility = visibility;
    }
}

