/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.modelhandler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSelectorAdapter;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetAdapter;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeAdapterFactory;
import org.eclipse.wst.html.core.internal.document.HTMLModelParserAdapterFactory;
import org.eclipse.wst.html.core.internal.htmlcss.HTMLStyleSelectorAdapterFactory;
import org.eclipse.wst.html.core.internal.htmlcss.StyleAdapterFactory;
import org.eclipse.wst.html.core.internal.modelhandler.ModelHandlerForHTML;
import org.eclipse.wst.html.core.internal.modelquery.ModelQueryAdapterFactoryForEmbeddedHTML;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.EmbeddedTypeHandler;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockMarker;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockTagParser;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.util.Assert;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.document.ModelParserAdapter;

public class EmbeddedHTML
implements EmbeddedTypeHandler {
    public String ContentTypeID_EmbeddedHTML = "org.eclipse.wst.html.core.internal.contenttype.EmbeddedHTML";
    private List supportedMimeTypes;

    private void addHTMLishTag(BlockTagParser parser, String tagname) {
        BlockMarker bm = new BlockMarker(tagname, null, "BLOCK_TEXT", false);
        parser.addBlockMarker(bm);
    }

    @Override
    public String getFamilyId() {
        return ModelHandlerForHTML.AssociatedContentTypeID;
    }

    @Override
    public List getAdapterFactories() {
        ArrayList<ModelQueryAdapterFactoryForEmbeddedHTML> factories = new ArrayList<ModelQueryAdapterFactoryForEmbeddedHTML>();
        factories.add(new ModelQueryAdapterFactoryForEmbeddedHTML());
        return factories;
    }

    @Override
    public void initializeParser(RegionParser parser) {
        if (parser instanceof BlockTagParser) {
            BlockTagParser blockTagParser = (BlockTagParser)((Object)parser);
            this.addHTMLishTag(blockTagParser, "script");
            this.addHTMLishTag(blockTagParser, "style");
        }
    }

    @Override
    public List getSupportedMimeTypes() {
        if (this.supportedMimeTypes == null) {
            this.supportedMimeTypes = new ArrayList();
            this.supportedMimeTypes.add("text/html");
            this.supportedMimeTypes.add("text/xhtml");
            this.supportedMimeTypes.add("application/xhtml+xml");
            this.supportedMimeTypes.add("text/vnd.wap.wml");
        }
        return this.supportedMimeTypes;
    }

    @Override
    public void initializeFactoryRegistry(FactoryRegistry registry) {
        Assert.isNotNull(registry);
        INodeAdapterFactory factory = null;
        if (!registry.contains(DocumentTypeAdapter.class)) {
            factory = HTMLDocumentTypeAdapterFactory.getInstance();
            registry.addFactory(factory);
        }
        if (!registry.contains(ModelParserAdapter.class)) {
            factory = HTMLModelParserAdapterFactory.getInstance();
            registry.addFactory(factory);
        }
        if (!registry.contains(IStyleSelectorAdapter.class)) {
            factory = HTMLStyleSelectorAdapterFactory.getInstance();
            registry.addFactory(factory);
        }
        if (!registry.contains(IStyleSheetAdapter.class)) {
            factory = StyleAdapterFactory.getInstance();
            registry.addFactory(factory);
        }
    }

    @Override
    public void uninitializeFactoryRegistry(FactoryRegistry registry) {
        Assert.isNotNull(registry);
        INodeAdapterFactory factory = null;
        if (!registry.contains(DocumentTypeAdapter.class)) {
            factory = registry.getFactoryFor(DocumentTypeAdapter.class);
            factory.release();
            registry.removeFactory(factory);
        }
        if (!registry.contains(ModelParserAdapter.class)) {
            factory = registry.getFactoryFor(ModelParserAdapter.class);
            factory.release();
            registry.removeFactory(factory);
        }
        if (!registry.contains(IStyleSelectorAdapter.class)) {
            factory = registry.getFactoryFor(IStyleSelectorAdapter.class);
            factory.release();
            registry.removeFactory(factory);
        }
        if (!registry.contains(IStyleSheetAdapter.class)) {
            factory = registry.getFactoryFor(IStyleSheetAdapter.class);
            factory.release();
            registry.removeFactory(factory);
        }
    }

    @Override
    public void uninitializeParser(RegionParser parser) {
        if (parser instanceof BlockTagParser) {
            ((BlockTagParser)((Object)parser)).removeBlockMarker("style");
            ((BlockTagParser)((Object)parser)).removeBlockMarker("script");
        }
    }

    @Override
    public EmbeddedTypeHandler newInstance() {
        return new EmbeddedHTML();
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public boolean canHandleMimeType(String mimeType) {
        return this.getSupportedMimeTypes().contains(mimeType);
    }
}

