/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.htmlcss;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSelectorAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSimpleSelector;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.w3c.dom.Element;

public class HTMLStyleSelectorAdapter
implements IStyleSelectorAdapter {
    private static HTMLStyleSelectorAdapter instance;
    private Object toMatch = IStyleSelectorAdapter.class;

    public static synchronized HTMLStyleSelectorAdapter getInstance() {
        if (instance == null) {
            instance = new HTMLStyleSelectorAdapter();
        }
        return instance;
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return type == this.toMatch;
    }

    @Override
    public boolean match(ICSSSimpleSelector selector, Element element, String pseudoName) {
        StringTokenizer tokenizer;
        String key;
        if (element == null) {
            return false;
        }
        int i = selector.getNumOfPseudoNames();
        if (i > 0) {
            if (pseudoName == null || pseudoName.length() == 0) {
                return false;
            }
            --i;
            while (i >= 0) {
                if (pseudoName.equalsIgnoreCase(selector.getPseudoName(i))) break;
                --i;
            }
            if (i < 0) {
                return false;
            }
        }
        if (!selector.isUniversal() && !element.getNodeName().equalsIgnoreCase(selector.getName())) {
            return false;
        }
        i = selector.getNumOfIDs();
        if (i > 0) {
            if (i > 1) {
                return false;
            }
            if (!element.hasAttribute("id") || (key = element.getAttribute("id")).length() == 0) {
                return false;
            }
            if (!selector.getID(0).equals(key)) {
                return false;
            }
        }
        if ((i = selector.getNumOfClasses()) > 0) {
            if (!element.hasAttribute("class") || (key = element.getAttribute("class")).length() == 0) {
                return false;
            }
            tokenizer = new StringTokenizer(key);
            --i;
            while (i >= 0) {
                boolean ok = false;
                while (tokenizer.hasMoreTokens()) {
                    if (!selector.getClass(i).equals(tokenizer.nextToken())) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    return false;
                }
                --i;
            }
        }
        i = selector.getNumOfAttributes() - 1;
        while (i >= 0) {
            tokenizer = new StringTokenizer(selector.getAttribute(i), "=~| \t\r\n\f");
            int countTokens = tokenizer.countTokens();
            if (countTokens > 0) {
                String attrName = tokenizer.nextToken();
                String attrValue = null;
                if (!element.hasAttribute(attrName) || (attrValue = element.getAttribute(attrName)).length() == 0) {
                    return false;
                }
                if (countTokens > 1) {
                    String token = tokenizer.nextToken("= \t\r\n\f");
                    StringTokenizer attrValueTokenizer = null;
                    if (token.equals("~")) {
                        attrValueTokenizer = new StringTokenizer(attrValue);
                    } else if (token.equals("|")) {
                        attrValueTokenizer = new StringTokenizer(attrValue, "-");
                    }
                    if (attrValueTokenizer != null) {
                        if (tokenizer.hasMoreTokens()) {
                            token = tokenizer.nextToken();
                            boolean ok = false;
                            while (attrValueTokenizer.hasMoreTokens()) {
                                if (!token.equals(attrValueTokenizer.nextToken())) continue;
                                ok = true;
                                break;
                            }
                            if (!ok) {
                                return false;
                            }
                        }
                    } else if (!attrValue.equals(token)) {
                        return false;
                    }
                }
            }
            --i;
        }
        return true;
    }

    @Override
    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }
}

