/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.contenttype;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.wst.css.core.internal.contenttype.ByteReader;
import org.eclipse.wst.css.core.internal.contenttype.CSSHeadTokenizer;
import org.eclipse.wst.css.core.internal.contenttype.EncodingGuesser;
import org.eclipse.wst.css.core.internal.contenttype.HeadParserToken;
import org.eclipse.wst.sse.core.internal.encoding.CodedIO;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.IResourceCharsetDetector;
import org.eclipse.wst.sse.core.internal.encoding.NonContentBasedEncodingRules;

public class CSSResourceEncodingDetector
implements IResourceCharsetDetector {
    private CSSHeadTokenizer fTokenizer;
    private EncodingMemento fEncodingMemento;
    private boolean fHeaderParsed;
    private Reader fReader;

    @Override
    public String getSpecDefaultEncoding() {
        return null;
    }

    private boolean canHandleAsUnicodeStream(String tokenType) {
        boolean canHandleAsUnicodeStream = false;
        if (tokenType == "UTF83ByteBOM") {
            canHandleAsUnicodeStream = true;
            String enc = "UTF-8";
            this.createEncodingMemento(enc, "detectedStandardUnicodeBytes");
            this.fEncodingMemento.setUTF83ByteBOMUsed(true);
        } else if (tokenType == "UTF16BE" || tokenType == "UTF16LE") {
            canHandleAsUnicodeStream = true;
            String enc = "UTF-16";
            byte[] bom = tokenType == "UTF16BE" ? IContentDescription.BOM_UTF_16BE : IContentDescription.BOM_UTF_16LE;
            this.createEncodingMemento(enc, "detectedStandardUnicodeBytes");
            this.fEncodingMemento.setUnicodeStream(true);
            this.fEncodingMemento.setUnicodeBOM(bom);
        }
        return canHandleAsUnicodeStream;
    }

    private CSSHeadTokenizer getTokenizer() {
        if (this.fTokenizer == null) {
            this.fTokenizer = new CSSHeadTokenizer();
        }
        return this.fTokenizer;
    }

    private boolean isLegalString(String valueTokenType) {
        boolean result = false;
        if (valueTokenType != null) {
            result = valueTokenType.equals("strval") || valueTokenType.equals("UnDelimitedStringValue") || valueTokenType.equals("InvalidTerminatedStringValue") || valueTokenType.equals("InvalidTermintatedUnDelimitedStringValue");
        }
        return result;
    }

    private void parseInput() throws IOException {
        this.checkInContents();
        if (this.fEncodingMemento == null) {
            this.checkHeuristics();
        }
    }

    private void checkInContents() throws IOException {
        CSSHeadTokenizer tokenizer = this.getTokenizer();
        tokenizer.reset(this.fReader);
        HeadParserToken token = null;
        String tokenType = null;
        do {
            HeadParserToken valueToken;
            String valueTokenType;
            if (this.canHandleAsUnicodeStream(tokenType = (token = tokenizer.getNextToken()).getType()) || tokenType != "CHARSET_RULE" || !tokenizer.hasMoreTokens() || !this.isLegalString(valueTokenType = (valueToken = tokenizer.getNextToken()).getType())) continue;
            this.createEncodingMemento(valueToken.getText(), "foundEncodingInContent");
        } while (tokenizer.hasMoreTokens());
    }

    private void checkHeuristics() throws IOException {
        String heuristicEncoding;
        block12: {
            boolean noHeuristic = false;
            heuristicEncoding = null;
            try {
                try {
                    this.fReader.reset();
                    byte[] bytes = new byte[3];
                    int nRead = 0;
                    int i = 0;
                    while (i < bytes.length) {
                        if (this.fReader.ready()) {
                            int oneByte = this.fReader.read();
                            ++nRead;
                            if (oneByte <= 255) {
                                bytes[i] = (byte)oneByte;
                            } else {
                                noHeuristic = true;
                            }
                        } else {
                            noHeuristic = true;
                            break;
                        }
                        ++i;
                    }
                    if (!noHeuristic && nRead == 3) {
                        heuristicEncoding = EncodingGuesser.guessEncoding(bytes, 3);
                    }
                }
                catch (IOException iOException) {
                    this.fReader.reset();
                    break block12;
                }
            }
            catch (Throwable throwable) {
                this.fReader.reset();
                throw throwable;
            }
            this.fReader.reset();
        }
        if (heuristicEncoding != null) {
            this.createEncodingMemento(heuristicEncoding, "GuessEncodingFromStream");
        }
    }

    private void createEncodingMemento(String detectedCharsetName) {
        this.fEncodingMemento = new EncodingMemento();
        this.fEncodingMemento.setJavaCharsetName(this.getAppropriateJavaCharset(detectedCharsetName));
        this.fEncodingMemento.setDetectedCharsetName(detectedCharsetName);
        this.fEncodingMemento.setAppropriateDefault(this.getSpecDefaultEncoding());
    }

    private void createEncodingMemento(String detectedCharsetName, String reason) {
        this.createEncodingMemento(detectedCharsetName);
    }

    private final void ensureInputSet() {
        if (this.fReader == null) {
            throw new IllegalStateException("input must be set before use");
        }
    }

    private String getAppropriateJavaCharset(String detectedCharsetName) {
        Charset javaCharset;
        String result;
        block5: {
            result = null;
            result = CodedIO.checkMappingOverrides(detectedCharsetName);
            javaCharset = null;
            try {
                javaCharset = Charset.forName(detectedCharsetName);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                if (result != null && result.equals(detectedCharsetName)) {
                    this.fEncodingMemento.setInvalidEncoding(detectedCharsetName);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                if (result == null || !result.equals(detectedCharsetName)) break block5;
                this.fEncodingMemento.setInvalidEncoding(detectedCharsetName);
            }
        }
        if (javaCharset != null) {
            result = javaCharset.name();
            result = CodedIO.checkMappingOverrides(result);
        }
        return result;
    }

    @Override
    public String getEncoding() throws IOException {
        return this.getEncodingMemento().getDetectedCharsetName();
    }

    public EncodingMemento getEncodingMemento() throws IOException {
        this.ensureInputSet();
        if (!this.fHeaderParsed) {
            this.parseInput();
            this.fHeaderParsed = true;
        }
        if (this.fEncodingMemento == null) {
            this.handleSpecDefault();
        }
        if (this.fEncodingMemento == null) {
            this.fEncodingMemento = new NullMemento();
        }
        return this.fEncodingMemento;
    }

    public EncodingMemento getSpecDefaultEncodingMemento() {
        this.resetAll();
        EncodingMemento result = null;
        String enc = this.getSpecDefaultEncoding();
        if (enc != null) {
            this.createEncodingMemento(enc, "DefaultsAssumedForEmptyInput");
            this.fEncodingMemento.setAppropriateDefault(enc);
            result = this.fEncodingMemento;
        }
        return result;
    }

    private void handleSpecDefault() {
        String encodingName = this.getSpecDefaultEncoding();
        if (encodingName != null) {
            this.fEncodingMemento = new EncodingMemento();
            this.fEncodingMemento.setJavaCharsetName(encodingName);
            this.fEncodingMemento.setAppropriateDefault(encodingName);
        }
    }

    private void resetAll() {
        this.fReader = null;
        this.fHeaderParsed = false;
        this.fEncodingMemento = null;
    }

    @Override
    public void set(InputStream inputStream) {
        this.resetAll();
        this.fReader = new ByteReader(inputStream);
        try {
            this.fReader.mark(8192);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    @Override
    public void set(IStorage iStorage) throws CoreException {
        this.resetAll();
        InputStream inputStream = iStorage.getContents();
        BufferedInputStream resettableStream = new BufferedInputStream(inputStream, 8192);
        ((InputStream)resettableStream).mark(8192);
        this.set(resettableStream);
    }

    @Override
    public void set(Reader reader) {
        this.resetAll();
        this.fReader = reader;
        if (!this.fReader.markSupported()) {
            this.fReader = new BufferedReader(this.fReader);
        }
        try {
            this.fReader.mark(8192);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    class NullMemento
    extends EncodingMemento {
        public NullMemento() {
            String defaultCharset = NonContentBasedEncodingRules.useDefaultNameRules(null);
            this.setJavaCharsetName(defaultCharset);
            this.setAppropriateDefault(defaultCharset);
            this.setDetectedCharsetName(null);
        }
    }
}

