/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.cleanup;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.css.core.internal.formatter.CSSFormatUtil;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatterFactory;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceGenerator;
import org.eclipse.wst.css.core.internal.provisional.contenttype.ContentTypeIdForCSS;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.sse.core.internal.cleanup.AbstractStructuredCleanupProcessor;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupHandler;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;

public class CleanupProcessorCSS
extends AbstractStructuredCleanupProcessor {
    @Override
    public void cleanupModel(IStructuredModel structuredModel, int start, int length) {
        List cssnodes;
        CSSFormatUtil formatUtil = CSSFormatUtil.getInstance();
        if (structuredModel instanceof ICSSModel) {
            ICSSDocument doc = ((ICSSModel)structuredModel).getDocument();
            CSSSourceGenerator formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter((INodeNotifier)((Object)doc));
            StringBuffer buf = formatter.cleanup(doc);
            if (buf != null) {
                int startOffset = ((IndexedRegion)((Object)doc)).getStartOffset();
                int endOffset = ((IndexedRegion)((Object)doc)).getEndOffset();
                formatUtil.replaceSource(doc.getModel(), startOffset, endOffset - startOffset, buf.toString());
            }
        } else if (structuredModel instanceof IDOMModel && (cssnodes = formatUtil.collectCSSNodes(structuredModel, start, length)) != null && !cssnodes.isEmpty()) {
            ICSSModel model = null;
            int i = 0;
            while (i < cssnodes.size()) {
                ICSSNode node = (ICSSNode)cssnodes.get(i);
                CSSSourceGenerator formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter((INodeNotifier)((Object)node));
                StringBuffer buf = formatter.cleanup(node);
                if (buf != null) {
                    int startOffset = ((IndexedRegion)((Object)node)).getStartOffset();
                    int endOffset = ((IndexedRegion)((Object)node)).getEndOffset();
                    if (model == null) {
                        model = node.getOwnerDocument().getModel();
                    }
                    formatUtil.replaceSource(model, startOffset, endOffset - startOffset, buf.toString());
                }
                ++i;
            }
        }
    }

    @Override
    protected String getContentType() {
        return ContentTypeIdForCSS.ContentTypeID_CSS;
    }

    @Override
    public void cleanupModel(IStructuredModel structuredModel) {
        int start = 0;
        int length = structuredModel.getStructuredDocument().getLength();
        this.cleanupModel(structuredModel, start, length);
    }

    @Override
    public void cleanupDocument(IDocument document) throws IOException, CoreException {
    }

    @Override
    public void cleanupDocument(IDocument document, int start, int length) throws IOException, CoreException {
    }

    @Override
    protected IStructuredCleanupHandler getCleanupHandler(Node node) {
        return null;
    }

    @Override
    protected IStructuredFormatProcessor getFormatProcessor() {
        return null;
    }

    @Override
    protected void refreshCleanupPreferences() {
    }
}

