/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.pde;

import com.diffplug.common.base.StringPrinter;
import com.diffplug.gradle.pde.PluginCatalog;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Version;

public class ProductFileUtil {
    private static final String PLUGIN_PREFIX = "<plugin id=\"";
    private static final String PLUGIN_MIDDLE = "\"";
    private static final String PLUGIN_SUFFIX = "/>";
    private static final String GROUP = "(.*)";
    private static final String NO_QUOTE_GROUP = "([^\"]*)";
    private static final Pattern PLUGIN_REGEX = Pattern.compile("(.*)<plugin id=\"([^\"]*)\"(.*)/>");
    private static final Pattern PRODUCT_VERSION_REGEX = Pattern.compile("<product (?:.*) version=\"([^\"]*)\"(?:.*)>");
    private static final String VERSION_EQ = "version=";

    static void transformProductFile(StringPrinter printer, String line, PluginCatalog catalog, String version) {
        Matcher pluginMatcher;
        Matcher productMatcher = PRODUCT_VERSION_REGEX.matcher(line);
        if (productMatcher.matches()) {
            int start = productMatcher.start(1);
            int end = productMatcher.end(1);
            printer.println(line.substring(0, start) + version + line.substring(end));
            return;
        }
        if (!line.contains("plugin") || line.contains("plugins")) {
            printer.println(line);
            return;
        }
        if (line.contains(VERSION_EQ)) {
            System.err.println("Ignoring version in " + line + ", Goomph sets it automatically.");
            int versionStart = line.indexOf(VERSION_EQ);
            int versionEnd = line.indexOf(34, versionStart + VERSION_EQ.length() + 1);
            line = line.substring(0, versionStart) + line.substring(versionEnd + 1);
        }
        if ((pluginMatcher = PLUGIN_REGEX.matcher(line)).matches()) {
            String pluginName = pluginMatcher.group(2);
            if (!catalog.isSupportedPlatform(pluginName)) {
                return;
            }
            for (Version pluginVersion : catalog.getVersionsFor(pluginName)) {
                printer.println(pluginMatcher.group(1) + PLUGIN_PREFIX + pluginName + PLUGIN_MIDDLE + " version=\"" + pluginVersion + PLUGIN_MIDDLE + pluginMatcher.group(3) + PLUGIN_SUFFIX);
            }
        } else {
            System.err.println("Unexpected line " + line);
        }
    }

    static Optional<String> parsePlugin(String line) {
        if (!line.contains("plugin") || line.contains("plugins")) {
            return Optional.empty();
        }
        Matcher pluginMatcher = PLUGIN_REGEX.matcher(line);
        if (pluginMatcher.matches()) {
            String pluginName = pluginMatcher.group(2);
            return Optional.of(pluginName);
        }
        return Optional.empty();
    }
}

