/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.pde;

import com.diffplug.common.base.Preconditions;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.eclipserunner.EclipseApp;
import com.diffplug.gradle.pde.PdeInstallation;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;

public class PdeAntBuildTask
extends DefaultTask {
    private Object antFile;
    private Map<String, String> buildProperties = new LinkedHashMap<String, String>();

    public void antFile(Object antFile) {
        this.antFile = antFile;
    }

    public void define(String key, String value) {
        this.buildProperties.put(key, value);
    }

    public void defineToFile(String key, Object value) {
        this.buildProperties.put(key, this.getProject().file(value).getAbsolutePath());
    }

    @TaskAction
    public void build() throws Exception {
        Preconditions.checkNotNull((Object)this.antFile, (Object)"antFile must not be null!");
        EclipseApp antRunner = new EclipseApp("org.eclipse.ant.core.antRunner");
        antRunner.addArg("buildfile", this.getProject().file(this.antFile).getAbsolutePath());
        this.buildProperties.forEach((key, value) -> antRunner.addArg("D" + key + "=" + FileMisc.quote(value)));
        antRunner.runUsing(PdeInstallation.fromProject(this.getProject()));
    }
}

