/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipse;

import com.diffplug.common.base.Preconditions;
import com.diffplug.common.collect.Iterables;
import com.diffplug.gradle.ProjectPlugin;
import com.diffplug.gradle.eclipse.EclipseProjectPlugin;
import com.diffplug.gradle.eclipse.ProjectDepsExtension;
import groovy.util.Node;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;

public class ProjectDepsPlugin
extends ProjectPlugin {
    @Override
    protected void applyOnce(Project project) {
        ProjectDepsExtension extension = (ProjectDepsExtension)project.getExtensions().create("eclipseProjectDeps", ProjectDepsExtension.class, new Object[0]);
        EclipseProjectPlugin.modifyEclipseProject(project, eclipseModel -> {
            Task prepareEclipse = project.task("prepareEclipse");
            prepareEclipse.doLast(task -> {
                Set referencedProjects = eclipseModel.getProject().getReferencedProjects();
                project.getConfigurations().stream().flatMap(config -> config.getDependencies().stream()).filter(dep -> dep instanceof ProjectDependency).forEach(dep -> referencedProjects.add(dep.getName()));
            });
            ((Task)Iterables.getOnlyElement((Iterable)project.getTasksByName("eclipseClasspath", false))).dependsOn(new Object[]{prepareEclipse});
            ((Task)Iterables.getOnlyElement((Iterable)project.getTasksByName("eclipseProject", false))).dependsOn(new Object[]{prepareEclipse});
            eclipseModel.getClasspath().getFile().getXmlTransformer().addAction(xmlProvider -> this.modifyClasspath(xmlProvider.asNode(), (EclipseModel)eclipseModel, extension));
        });
    }

    private void modifyClasspath(Node classpathNode, EclipseModel eclipseModel, ProjectDepsExtension extension) {
        ArrayList<String> jarDeps = new ArrayList<String>();
        Iterator classpathEntries = classpathNode.children().iterator();
        while (classpathEntries.hasNext()) {
            Node entry = (Node)classpathEntries.next();
            String path = (String)entry.attributes().get("path");
            if (path == null || path.isEmpty()) continue;
            if (path.endsWith(".jar")) {
                jarDeps.add(ProjectDepsPlugin.parseLibraryName(path));
                continue;
            }
            if (!eclipseModel.getProject().getReferencedProjects().contains(path.substring(1))) continue;
            classpathEntries.remove();
        }
        Consumer<String> addProject = projectDep -> {
            Node entry = classpathNode.appendNode((Object)"classpathentry");
            entry.attributes().put("combineaccessrules", "true");
            entry.attributes().put("exported", "true");
            entry.attributes().put("kind", "src");
            entry.attributes().put("path", "/" + projectDep);
        };
        eclipseModel.getProject().getReferencedProjects().forEach(addProject);
        for (String jarToReplace : extension.jarsToReplace) {
            String matching = "";
            for (String jarDep : jarDeps) {
                if (jarDep.length() <= matching.length() || !jarDep.startsWith(jarToReplace)) continue;
                matching = jarDep;
            }
            if (matching.isEmpty()) continue;
            String jar = "/" + matching + ".jar";
            classpathEntries = classpathNode.children().iterator();
            while (classpathEntries.hasNext()) {
                Node entry = (Node)classpathEntries.next();
                String path = (String)entry.attributes().get("path");
                if (path == null || !path.endsWith(jar)) continue;
                classpathEntries.remove();
            }
            addProject.accept(jarToReplace);
        }
    }

    static String parseLibraryName(String input) {
        Preconditions.checkArgument((boolean)input.endsWith(".jar"));
        int lastIdx = input.lastIndexOf(47);
        return input.substring(lastIdx + 1, input.length() - 4);
    }
}

