/*
 * Decompiled with CFR 0.152.
 */
package com.didi.aoe.library.api;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.didi.aoe.library.api.AoeModelOption;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Map;

public interface AoeProcessor {
    public void setId(String var1);

    @NonNull
    public InterpreterComponent getInterpreterComponent();

    @Nullable
    public ParcelComponent getParcelComponent();

    public static interface ParcelComponent
    extends Component {
        public byte[] obj2Byte(@NonNull Object var1);

        public Object byte2Obj(@NonNull byte[] var1);
    }

    public static interface Convertor<TInput, TOutput, TModelInput, TModelOutput> {
        @Nullable
        public TModelInput preProcess(@NonNull TInput var1);

        @Nullable
        public TOutput postProcess(@Nullable TModelOutput var1);
    }

    public static interface MultiConvertor<TInput, TOutput, TModelInput, TModelOutput> {
        @Nullable
        public TModelInput[] preProcessMulti(@NonNull TInput var1);

        @Nullable
        public TOutput postProcessMulti(@Nullable Map<Integer, TModelOutput> var1);
    }

    public static class InitResult {
        private int code;
        private String msg;

        private InitResult(int code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public String toString() {
            return "InitResult{code=" + this.code + ", msg='" + this.msg + '\'' + '}';
        }

        public static InitResult create(int code) {
            return new InitResult(code, InitResult.generalCodeName(code));
        }

        private static String generalCodeName(int code) {
            String codeName;
            switch (code) {
                case -2: {
                    codeName = "STATUS_INNER_ERROR";
                    break;
                }
                case -1: {
                    codeName = "STATUS_UNDEFINE";
                    break;
                }
                case 0: {
                    codeName = "STATUS_OK";
                    break;
                }
                case 1: {
                    codeName = "STATUS_CONFIG_PARSE_ERROR";
                    break;
                }
                case 2: {
                    codeName = "STATUS_CONNECTION_WAITING";
                    break;
                }
                case 3: {
                    codeName = "STATUS_MODEL_DOWNLOAD_WAITING";
                    break;
                }
                case 4: {
                    codeName = "STATUS_MODEL_LOAD_FAILED";
                    break;
                }
                default: {
                    codeName = "UNKNOWN";
                }
            }
            return codeName;
        }

        public static InitResult create(int code, String msg) {
            return new InitResult(code, msg);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.LOCAL_VARIABLE, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface StatusCode {
        public static final int STATUS_INNER_ERROR = -2;
        public static final int STATUS_UNDEFINE = -1;
        public static final int STATUS_OK = 0;
        public static final int STATUS_CONFIG_PARSE_ERROR = 1;
        public static final int STATUS_CONNECTION_WAITING = 2;
        public static final int STATUS_MODEL_DOWNLOAD_WAITING = 3;
        public static final int STATUS_MODEL_LOAD_FAILED = 4;
    }

    public static interface OnInitListener {
        public void onInitResult(@NonNull InitResult var1);
    }

    public static interface InterpreterComponent<TInput, TOutput>
    extends Component {
        public void init(@NonNull Context var1, @NonNull List<AoeModelOption> var2, @Nullable OnInitListener var3);

        @Nullable
        public TOutput run(@NonNull TInput var1);

        public void release();

        public boolean isReady();
    }

    @FunctionalInterface
    public static interface ModelOptionLoaderComponent
    extends Component {
        public AoeModelOption load(@NonNull Context var1, @NonNull String var2);
    }

    public static interface Component {
    }
}

