/*
 * Decompiled with CFR 0.152.
 */
package com.dhh.websocket;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import com.dhh.websocket.WebSocketSubscriber;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import rx.Observable;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public abstract class WebSocketSubscriber2<T>
extends WebSocketSubscriber {
    private static final Gson GSON = new Gson();
    protected Type type;

    public WebSocketSubscriber2() {
        this.analysisType();
    }

    private void analysisType() {
        Type superclass = ((Object)((Object)this)).getClass().getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new RuntimeException("No generics found!");
        }
        ParameterizedType type = (ParameterizedType)superclass;
        this.type = type.getActualTypeArguments()[0];
    }

    @Override
    @CallSuper
    protected void onMessage(@NonNull String text) {
        Observable.just((Object)text).map(new Func1<String, T>(){

            public T call(String s) {
                try {
                    return GSON.fromJson(s, WebSocketSubscriber2.this.type);
                }
                catch (JsonSyntaxException e) {
                    return GSON.fromJson((String)GSON.fromJson(s, String.class), WebSocketSubscriber2.this.type);
                }
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(new Action1<T>(){

            public void call(T t) {
                WebSocketSubscriber2.this.onMessage(t);
            }
        });
    }

    protected abstract void onMessage(T var1);
}

