/*
 * Decompiled with CFR 0.152.
 */
package com.dhh.websocket;

import android.support.annotation.NonNull;
import com.dhh.websocket.WebSocketInfo;
import okhttp3.WebSocket;
import okio.ByteString;
import rx.Subscriber;

public abstract class WebSocketSubscriber
extends Subscriber<WebSocketInfo> {
    private boolean hasOpened;

    public final void onNext(@NonNull WebSocketInfo webSocketInfo) {
        if (webSocketInfo.isOnOpen()) {
            this.hasOpened = true;
            this.onOpen(webSocketInfo.getWebSocket());
        } else if (webSocketInfo.getString() != null) {
            this.onMessage(webSocketInfo.getString());
        } else if (webSocketInfo.getByteString() != null) {
            this.onMessage(webSocketInfo.getByteString());
        } else if (webSocketInfo.isOnReconnect()) {
            this.onReconnect();
        }
    }

    protected void onOpen(@NonNull WebSocket webSocket) {
    }

    protected void onMessage(@NonNull String text) {
    }

    protected void onMessage(@NonNull ByteString byteString) {
    }

    protected void onReconnect() {
    }

    protected void onClose() {
    }

    public final void onCompleted() {
        if (this.hasOpened) {
            this.onClose();
        }
    }

    public void onError(Throwable e) {
        e.printStackTrace();
    }
}

