/*
 * Decompiled with CFR 0.152.
 */
package com.dhh.websocket;

import android.os.SystemClock;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.dhh.websocket.WebSocketInfo;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.MainThreadSubscription;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.schedulers.Schedulers;

public class RxWebSocketUtil {
    private static RxWebSocketUtil instance;
    private OkHttpClient client;
    private Map<String, Observable<WebSocketInfo>> observableMap;
    private Map<String, WebSocket> webSocketMap;
    private boolean showLog;
    private String logTag = "RxWebSocket";
    private long interval = 1L;
    private TimeUnit reconnectIntervalTimeUnit = TimeUnit.SECONDS;

    private RxWebSocketUtil() {
        try {
            Class.forName("okhttp3.OkHttpClient");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Must be dependency okhttp3 !");
        }
        try {
            Class.forName("rx.Observable");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Must be dependency rxjava 1.x");
        }
        try {
            Class.forName("rx.android.schedulers.AndroidSchedulers");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Must be dependency rxandroid 1.x");
        }
        this.observableMap = new ArrayMap();
        this.webSocketMap = new ArrayMap();
        this.client = new OkHttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static RxWebSocketUtil getInstance() {
        if (instance != null) return instance;
        Class<RxWebSocketUtil> clazz = RxWebSocketUtil.class;
        synchronized (RxWebSocketUtil.class) {
            if (instance != null) return instance;
            instance = new RxWebSocketUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setClient(OkHttpClient client) {
        if (client == null) {
            throw new NullPointerException(" Are you stupid ? client == null");
        }
        this.client = client;
    }

    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
        this.client = this.client.newBuilder().sslSocketFactory(sslSocketFactory, trustManager).build();
    }

    public void setShowLog(boolean showLog) {
        this.showLog = showLog;
    }

    public void setShowLog(boolean showLog, String logTag) {
        this.setShowLog(showLog);
        this.logTag = logTag;
    }

    public void setReconnectInterval(long interval, TimeUnit timeUnit) {
        this.interval = interval;
        this.reconnectIntervalTimeUnit = timeUnit;
    }

    public Observable<WebSocketInfo> getWebSocketInfo(final String url, long timeout, TimeUnit timeUnit) {
        Observable observable = this.observableMap.get(url);
        if (observable == null) {
            observable = Observable.create((Observable.OnSubscribe)new WebSocketOnSubscribe(url)).timeout(timeout, timeUnit).retry((Func2)new Func2<Integer, Throwable, Boolean>(){

                public Boolean call(Integer integer, Throwable throwable) {
                    return throwable instanceof IOException;
                }
            }).doOnUnsubscribe(new Action0(){

                public void call() {
                    RxWebSocketUtil.this.observableMap.remove(url);
                    RxWebSocketUtil.this.webSocketMap.remove(url);
                    if (RxWebSocketUtil.this.showLog) {
                        Log.d((String)RxWebSocketUtil.this.logTag, (String)"unsubscribe");
                    }
                }
            }).doOnNext((Action1)new Action1<WebSocketInfo>(){

                public void call(WebSocketInfo webSocketInfo) {
                    if (webSocketInfo.isOnOpen()) {
                        RxWebSocketUtil.this.webSocketMap.put(url, webSocketInfo.getWebSocket());
                    }
                }
            }).share().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
            this.observableMap.put(url, (Observable<WebSocketInfo>)observable);
        } else {
            WebSocket webSocket = this.webSocketMap.get(url);
            if (webSocket != null) {
                observable = observable.startWith((Object)new WebSocketInfo(webSocket, true));
            }
        }
        return observable;
    }

    public Observable<WebSocketInfo> getWebSocketInfo(String url) {
        return this.getWebSocketInfo(url, 30L, TimeUnit.DAYS);
    }

    public Observable<String> getWebSocketString(String url) {
        return this.getWebSocketInfo(url).map((Func1)new Func1<WebSocketInfo, String>(){

            public String call(WebSocketInfo webSocketInfo) {
                return webSocketInfo.getString();
            }
        }).filter((Func1)new Func1<String, Boolean>(){

            public Boolean call(String s) {
                return s != null;
            }
        });
    }

    public Observable<ByteString> getWebSocketByteString(String url) {
        return this.getWebSocketInfo(url).map((Func1)new Func1<WebSocketInfo, ByteString>(){

            public ByteString call(WebSocketInfo webSocketInfo) {
                return webSocketInfo.getByteString();
            }
        }).filter((Func1)new Func1<ByteString, Boolean>(){

            public Boolean call(ByteString byteString) {
                return byteString != null;
            }
        });
    }

    public Observable<WebSocket> getWebSocket(String url) {
        return this.getWebSocketInfo(url).map((Func1)new Func1<WebSocketInfo, WebSocket>(){

            public WebSocket call(WebSocketInfo webSocketInfo) {
                return webSocketInfo.getWebSocket();
            }
        });
    }

    public void send(String url, String msg) {
        WebSocket webSocket = this.webSocketMap.get(url);
        if (webSocket == null) {
            throw new IllegalStateException("The WebSokcet not open");
        }
        webSocket.send(msg);
    }

    public void send(String url, ByteString byteString) {
        WebSocket webSocket = this.webSocketMap.get(url);
        if (webSocket == null) {
            throw new IllegalStateException("The WebSokcet not open");
        }
        webSocket.send(byteString);
    }

    public void asyncSend(String url, final String msg) {
        this.getWebSocket(url).first().subscribe((Action1)new Action1<WebSocket>(){

            public void call(WebSocket webSocket) {
                webSocket.send(msg);
            }
        });
    }

    public void asyncSend(String url, final ByteString byteString) {
        this.getWebSocket(url).first().subscribe((Action1)new Action1<WebSocket>(){

            public void call(WebSocket webSocket) {
                webSocket.send(byteString);
            }
        });
    }

    private Request getRequest(String url) {
        return new Request.Builder().get().url(url).build();
    }

    private final class WebSocketOnSubscribe
    implements Observable.OnSubscribe<WebSocketInfo> {
        private String url;
        private WebSocket webSocket;

        public WebSocketOnSubscribe(String url) {
            this.url = url;
        }

        public void call(Subscriber<? super WebSocketInfo> subscriber) {
            if (this.webSocket != null && !"main".equals(Thread.currentThread().getName())) {
                long ms = RxWebSocketUtil.this.reconnectIntervalTimeUnit.toMillis(RxWebSocketUtil.this.interval);
                if (ms == 0L) {
                    ms = 1000L;
                }
                SystemClock.sleep((long)ms);
                subscriber.onNext((Object)WebSocketInfo.createReconnect());
            }
            this.initWebSocket(subscriber);
        }

        private void initWebSocket(final Subscriber<? super WebSocketInfo> subscriber) {
            this.webSocket = RxWebSocketUtil.this.client.newWebSocket(RxWebSocketUtil.this.getRequest(this.url), new WebSocketListener(){

                public void onOpen(WebSocket webSocket, Response response) {
                    if (RxWebSocketUtil.this.showLog) {
                        Log.d((String)RxWebSocketUtil.this.logTag, (String)(WebSocketOnSubscribe.this.url + " --> onOpen"));
                    }
                    RxWebSocketUtil.this.webSocketMap.put(WebSocketOnSubscribe.this.url, webSocket);
                    if (!subscriber.isUnsubscribed()) {
                        subscriber.onNext((Object)new WebSocketInfo(webSocket, true));
                    }
                }

                public void onMessage(WebSocket webSocket, String text) {
                    if (!subscriber.isUnsubscribed()) {
                        subscriber.onNext((Object)new WebSocketInfo(webSocket, text));
                    }
                }

                public void onMessage(WebSocket webSocket, ByteString bytes) {
                    if (!subscriber.isUnsubscribed()) {
                        subscriber.onNext((Object)new WebSocketInfo(webSocket, bytes));
                    }
                }

                public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                    if (RxWebSocketUtil.this.showLog) {
                        Log.e((String)RxWebSocketUtil.this.logTag, (String)(t.toString() + webSocket.request().url().uri().getPath()));
                    }
                    if (!subscriber.isUnsubscribed()) {
                        subscriber.onError(t);
                    }
                }

                public void onClosing(WebSocket webSocket, int code, String reason) {
                    webSocket.close(1000, null);
                }

                public void onClosed(WebSocket webSocket, int code, String reason) {
                    if (RxWebSocketUtil.this.showLog) {
                        Log.d((String)RxWebSocketUtil.this.logTag, (String)(WebSocketOnSubscribe.this.url + " --> onClosed:code= " + code));
                    }
                }
            });
            subscriber.add((Subscription)new MainThreadSubscription(){

                protected void onUnsubscribe() {
                    WebSocketOnSubscribe.this.webSocket.close(3000, "close WebSocket");
                }
            });
        }
    }
}

