/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.ide.sonarqube.common.impl.config;

import com.devonfw.ide.sonarqube.common.api.config.Configuration;
import com.devonfw.ide.sonarqube.common.impl.config.ConfigurationMapper;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigurationFactory {
    private static final ConfigurationFactory INSTANCE = new ConfigurationFactory();
    private final ConfigurationMapper mapper = new ConfigurationMapper();
    private final Map<String, Configuration> path2configMap = new HashMap<String, Configuration>();
    private String lastConfigFolderPath;

    public static Configuration get(File fileToScan) {
        return INSTANCE.getConfiguration(fileToScan);
    }

    public Configuration getConfiguration(File fileToScan) {
        Logger logger = Logger.getGlobal();
        if (this.lastConfigFolderPath != null && fileToScan.getAbsolutePath().startsWith(this.lastConfigFolderPath)) {
            return this.path2configMap.get(this.lastConfigFolderPath);
        }
        File configFile = ConfigurationFactory.findConfigFile(fileToScan.getAbsoluteFile().getParentFile());
        if (configFile == null) {
            logger.log(Level.INFO, () -> "********** Configuration not found starting from " + fileToScan.getAbsolutePath());
            return null;
        }
        logger.log(Level.INFO, () -> "********** Configuration found at " + configFile.getAbsolutePath());
        File configFolder = configFile.getParentFile();
        String configFolderPath = configFolder.getAbsolutePath();
        if (!configFolderPath.endsWith(File.separator)) {
            configFolderPath = configFolderPath + File.separator;
        }
        Configuration configuration = this.mapper.fromJson(configFile);
        this.path2configMap.put(configFolderPath, configuration);
        this.lastConfigFolderPath = configFolderPath;
        return configuration;
    }

    private static File findConfigFile(File folder) {
        if (folder == null) {
            return null;
        }
        File configFile = new File(folder, "architecture.json");
        if (configFile.exists()) {
            return configFile;
        }
        return ConfigurationFactory.findConfigFile(folder.getParentFile());
    }
}

