/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.ide.sonarqube.common.impl.check.naming;

import com.devonfw.ide.sonarqube.common.impl.check.DevonArchitectureCodeCheck;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.TypeTree;

public abstract class DevonNamingConventionInterfaceExtendsInterfaceCheck
extends DevonArchitectureCodeCheck {
    protected final Pattern extendingInterfaceSuffixRegEx;

    public DevonNamingConventionInterfaceExtendsInterfaceCheck(String extendingInterfaceSuffix) {
        this.extendingInterfaceSuffixRegEx = Pattern.compile(extendingInterfaceSuffix);
    }

    @Override
    public void doScanFile(ClassTree tree, JavaFileScannerContext context) {
        String interfaceName = tree.simpleName().name();
        Set<String> superInterfacesNames = this.getSuperInterfacesNames(tree);
        if (this.doesSuperInterfaceHaveRegEx(superInterfacesNames) && !this.doesInterfaceHaveRegEx(interfaceName)) {
            context.addIssue(tree.openBraceToken().line(), (JavaCheck)this, "If a superinterface has " + this.extendingInterfaceSuffixRegEx.toString() + " as suffix, then the subinterface should also have " + this.extendingInterfaceSuffixRegEx.toString() + " as suffix");
        }
    }

    protected Set<String> getSuperInterfacesNames(ClassTree tree) {
        LinkedHashSet<String> superInterfacesNames = new LinkedHashSet<String>();
        for (TypeTree typeTree : tree.superInterfaces()) {
            superInterfacesNames.add(typeTree.toString());
        }
        return superInterfacesNames;
    }

    protected boolean doesInterfaceHaveRegEx(String interfaceName) {
        return this.extendingInterfaceSuffixRegEx.matcher(interfaceName).matches();
    }

    protected boolean doesSuperInterfaceHaveRegEx(Set<String> superInterfaces) {
        for (String superInterface : superInterfaces) {
            if (!this.extendingInterfaceSuffixRegEx.matcher(superInterface).matches()) continue;
            return true;
        }
        return false;
    }
}

