/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.ide.sonarqube.common.impl.check.naming;

import com.devonfw.ide.sonarqube.common.impl.check.DevonArchitectureCodeCheck;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.TypeTree;

public abstract class DevonNamingConventionClassExtendsClassCheck
extends DevonArchitectureCodeCheck {
    protected final Pattern classSuffixRegEx;
    protected String className;
    protected String superClassName;

    public DevonNamingConventionClassExtendsClassCheck(String classSuffix) {
        this.classSuffixRegEx = Pattern.compile(classSuffix);
    }

    @Override
    public void doScanFile(ClassTree tree, JavaFileScannerContext context) {
        this.className = tree.simpleName().name();
        this.superClassName = this.getNameOfSuperClass(tree);
        if (this.isSuperClassMatching()) {
            this.checkClassNameAndCreateIssue(tree, context);
        }
    }

    protected boolean checkClassNameAndCreateIssue(ClassTree tree, JavaFileScannerContext context) {
        if (!this.isClassNameMatching()) {
            context.addIssue(tree.openBraceToken().line(), (JavaCheck)this, "If a superclass has " + this.classSuffixRegEx + " as suffix, then the subclass should also have " + this.classSuffixRegEx + " as suffix");
            return true;
        }
        return false;
    }

    protected String getNameOfSuperClass(ClassTree tree) {
        TypeTree superClass = tree.superClass();
        if (superClass == null) {
            return null;
        }
        return tree.superClass().toString();
    }

    protected List<String> getSuperInterfacesNames(ClassTree tree) {
        ListTree superInterfaces = tree.superInterfaces();
        ArrayList<String> superInterfacesNames = new ArrayList<String>();
        for (TypeTree superInterface : superInterfaces) {
            superInterfacesNames.add(superInterface.toString());
        }
        return superInterfacesNames;
    }

    protected static boolean isAbstract(ClassTree tree) {
        return ModifiersUtils.hasModifier((ModifiersTree)tree.modifiers(), (Modifier)Modifier.ABSTRACT);
    }

    protected boolean isClassNameMatching() {
        return this.classSuffixRegEx.matcher(this.className).matches();
    }

    protected boolean isSuperClassMatching() {
        if (this.superClassName == null) {
            return false;
        }
        return this.classSuffixRegEx.matcher(this.superClassName).matches();
    }
}

