/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.ide.sonarqube.common.impl.check.component;

import com.devonfw.ide.sonarqube.common.api.JavaType;
import com.devonfw.ide.sonarqube.common.api.config.Component;
import com.devonfw.ide.sonarqube.common.api.config.DevonArchitecturePackage;
import com.devonfw.ide.sonarqube.common.impl.check.DevonArchitectureComponentCheck;
import org.sonar.check.Priority;
import org.sonar.check.Rule;

@Rule(key="C4", name="devonfw Layer Service-Logic Component Check", priority=Priority.CRITICAL, tags={"architecture-violation", "devonfw", "component"})
public class DevonArchitectureLayerService2Logic4ComponentCheck
extends DevonArchitectureComponentCheck {
    @Override
    protected String checkDependency(JavaType source, Component sourceComponent, JavaType target) {
        DevonArchitecturePackage sourcePkg = source.getDevonPackage();
        DevonArchitecturePackage targetPkg = target.getDevonPackage();
        if (sourcePkg.isLayerService() && targetPkg.isLayerLogic()) {
            return "Code from service layer of a component shall not depend on logic layer of a different component. ('" + sourcePkg.getComponentAndLayer() + "' is dependent on '" + targetPkg.getComponentAndLayer() + "')";
        }
        return null;
    }
}

