/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.ide.sonarqube.common.impl;

import com.devonfw.ide.sonarqube.common.impl.DevonSonarDefinition;
import com.devonfw.ide.sonarqube.common.impl.DevonSonarRegistrar;
import com.devonfw.ide.sonarqube.common.impl.DevonfwJavaProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.api.Plugin;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;

public class SonarDevon4jPlugin
implements Plugin {
    private static final String DISABLED = "Disabled";
    private static final String QUALINSIGHT = "qualinsight-sonarqube-smell-plugin";
    private static final String PMD = "sonar-pmd-plugin";
    private static final String CHECKSTYLE = "checkstyle-sonar-plugin";
    private static final String FINDBUGS = "sonar-findbugs-plugin";
    private static List<String> forbiddenRepoKeys = new ArrayList<String>();
    private File pluginDirectory;
    private List<String> pluginList;

    SonarDevon4jPlugin(File pluginDirectory) {
        this.pluginDirectory = pluginDirectory;
    }

    public SonarDevon4jPlugin() {
        this(new File("extensions/plugins"));
    }

    public void define(Plugin.Context context) {
        String warningMessage = this.getMissingPlugins();
        context.addExtensions(DevonSonarDefinition.class, DevonSonarRegistrar.class, new Object[]{DevonfwJavaProfile.class});
        if (warningMessage != null) {
            context.addExtension((Object)PropertyDefinition.builder((String)DISABLED).name("Warning").description("Missing plugins for full initialization of devonfw quality profile").category("devonfw").subCategory("").type(PropertyType.TEXT).defaultValue(warningMessage).build());
        }
        this.disableRepoKeys();
    }

    private List<String> getPlugins() {
        if (this.pluginList == null) {
            File[] fileList = this.pluginDirectory.listFiles(f -> f.getName().endsWith(".jar") && f.isFile());
            this.pluginList = fileList != null ? Arrays.asList(fileList).stream().map(f -> f.getName()).collect(Collectors.toList()) : new ArrayList<String>();
        }
        return this.pluginList;
    }

    private boolean hasPlugin(String name) {
        for (String plugin : this.getPlugins()) {
            if (!plugin.contains(name)) continue;
            return true;
        }
        return false;
    }

    private void disableRepoKeys() {
        if (!this.hasPlugin(QUALINSIGHT)) {
            forbiddenRepoKeys.add("qualinsight-smells");
        }
        if (!this.hasPlugin(PMD)) {
            forbiddenRepoKeys.add("pmd");
            forbiddenRepoKeys.add("pmd-unit-tests");
        }
        if (!this.hasPlugin(CHECKSTYLE)) {
            forbiddenRepoKeys.add("checkstyle");
        }
        if (!this.hasPlugin(FINDBUGS)) {
            forbiddenRepoKeys.add("findbugs");
            forbiddenRepoKeys.add("findsecbugs");
            forbiddenRepoKeys.add("fb-contrib");
        }
    }

    private String getMissingPlugins() {
        StringBuilder missingPlugins = new StringBuilder();
        List<String> requiredPlugins = Arrays.asList(QUALINSIGHT, CHECKSTYLE, PMD, FINDBUGS);
        requiredPlugins.forEach(requiredPlugin -> {
            if (!this.hasPlugin((String)requiredPlugin)) {
                missingPlugins.append("- " + requiredPlugin + "\n");
            }
        });
        if (missingPlugins.length() != 0) {
            return missingPlugins.insert(0, "Please install plugins listed below: \n\n").toString();
        }
        return null;
    }

    static List<String> getForbiddenRepoKeys() {
        return forbiddenRepoKeys;
    }
}

