/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.ide.sonarqube.common.api.config;

import com.devonfw.ide.sonarqube.common.api.config.DevonPackage;
import com.devonfw.ide.sonarqube.common.api.config.Packages;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DevonPackageImpl
implements DevonPackage {
    public static final String GROUP_COMPONENT = "component";
    public static final String GROUP_LAYER = "layer";
    public static final String GROUP_SCOPE = "scope";
    public static final String GROUP_DETAIL = "detail";
    public static final String GROUP_IGNORE = "-";
    private static final Logger LOGGER = Logger.getLogger(DevonPackageImpl.class.getName());
    private final String packageName;
    private final boolean valid;
    private final String root;
    private final String component;
    private final String layer;
    private final String scope;
    private final String detail;
    private String application;
    private static final List<String> LAYERS = Arrays.asList("batch", "client", "common", "dataaccess", "logic", "service");
    private static final List<String> SCOPES = Arrays.asList("api", "base", "impl");

    public DevonPackageImpl(String packageName, boolean valid, String root, String component, String layer, String scope, String detail) {
        this.packageName = packageName;
        this.valid = valid;
        this.root = root;
        this.component = component;
        this.layer = layer;
        this.scope = scope;
        this.detail = detail;
    }

    @Override
    public String getPackage() {
        return this.packageName;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public String getRoot() {
        return this.root;
    }

    @Override
    public String getComponent() {
        return this.component;
    }

    @Override
    public String getLayer() {
        return this.layer;
    }

    @Override
    public boolean isValidLayer() {
        return LAYERS.contains(this.layer);
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public boolean isValidScope() {
        return SCOPES.contains(this.scope);
    }

    @Override
    public String getApplication() {
        if (this.application == null) {
            int lastIndexOfRoot = this.root.lastIndexOf(".");
            this.application = lastIndexOfRoot > 0 ? this.root.substring(lastIndexOfRoot + 1) : this.root;
        }
        return this.application;
    }

    @Override
    public String getDetail() {
        return this.detail;
    }

    public String toString() {
        return this.packageName;
    }

    static DevonPackage ofOriginal(String packageName, Packages packages) {
        String root = "";
        boolean valid = false;
        String component = "";
        String layer = "";
        String scope = "";
        String detail = "";
        Pattern pattern = packages.patternRegex();
        Matcher matcher = pattern.matcher(packageName);
        int i = 1;
        if (matcher.find()) {
            int segments;
            int start = matcher.start();
            int end = matcher.end();
            if (start >= 1 && (segments = DevonPackageImpl.countChars(root = packageName.substring(0, start - 1), '.') + 1) >= packages.getMinimumRootSegments() && end == packageName.length()) {
                valid = true;
                int groupCount = matcher.groupCount();
                for (String group : packages.getGroups()) {
                    if (i > groupCount) {
                        LOGGER.log(Level.WARNING, "The package '" + packageName + "' contains more groups than declared in your architecture.json.");
                        break;
                    }
                    String value = matcher.group(i);
                    switch (group) {
                        case "layer": {
                            layer = value;
                            break;
                        }
                        case "component": {
                            component = value;
                            break;
                        }
                        case "scope": {
                            scope = value;
                            break;
                        }
                        case "detail": {
                            detail = value;
                            break;
                        }
                        case "-": {
                            break;
                        }
                        default: {
                            LOGGER.log(Level.WARNING, "The group '" + group + "' is unknown.");
                        }
                    }
                    ++i;
                }
            }
        }
        return new DevonPackageImpl(packageName, valid, root, component, layer, scope, detail);
    }

    private static int countChars(String string, char c) {
        int count = 0;
        int i = 0;
        while (i >= 0) {
            i = string.indexOf(c, i);
            ++count;
            if (i < 0) continue;
            ++i;
        }
        return count;
    }
}

