/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.ide.sonarqube.common.api.config;

public interface DevonPackage {
    public static final String SCOPE_API = "api";
    public static final String SCOPE_BASE = "base";
    public static final String SCOPE_IMPLEMENTATION = "impl";
    public static final String LAYER_COMMON = "common";
    public static final String LAYER_DATA_ACCESS = "dataaccess";
    public static final String LAYER_LOGIC = "logic";
    public static final String LAYER_SERVICE = "service";
    public static final String LAYER_BATCH = "batch";
    public static final String LAYER_CLIENT = "client";

    public String getPackage();

    public boolean isValid();

    public String getRoot();

    default public boolean hasSameRoot(DevonPackage otherPkg) {
        return this.getRoot().equals(otherPkg.getRoot());
    }

    public String getComponent();

    default public String getComponentAndLayer() {
        return DevonPackage.composePackage(this.getComponent(), this.getLayer());
    }

    default public String getComponentAndLayerAndScope() {
        return DevonPackage.composePackage(this.getComponentAndLayer(), this.getScope());
    }

    default public boolean hasSameComponent(DevonPackage otherPkg) {
        return this.getComponent().equals(otherPkg.getComponent());
    }

    default public boolean isComponentGeneral() {
        return "general".equals(this.getComponent());
    }

    default public boolean hasSameComponentPart(DevonPackage otherPkg) {
        return this.hasSameComponent(otherPkg) && this.hasSameLayer(otherPkg) && this.hasSameRoot(otherPkg);
    }

    public String getLayer();

    default public boolean hasSameLayer(DevonPackage otherPkg) {
        return this.getLayer().equals(otherPkg.getLayer());
    }

    public boolean isValidLayer();

    default public boolean isLayerBatch() {
        return LAYER_BATCH.equals(this.getLayer());
    }

    default public boolean isLayerClient() {
        return LAYER_CLIENT.equals(this.getLayer());
    }

    default public boolean isLayerCommon() {
        return LAYER_COMMON.equals(this.getLayer());
    }

    default public boolean isLayerDataAccess() {
        return LAYER_DATA_ACCESS.equals(this.getLayer());
    }

    default public boolean isLayerLogic() {
        return LAYER_LOGIC.equals(this.getLayer());
    }

    default public boolean isLayerService() {
        return LAYER_SERVICE.equals(this.getLayer());
    }

    default public String getScope() {
        return this.getScope();
    }

    public boolean isValidScope();

    default public boolean isScopeApi() {
        return SCOPE_API.equals(this.getScope());
    }

    default public boolean isScopeBase() {
        return SCOPE_BASE.equals(this.getScope());
    }

    default public boolean isScopeImpl() {
        return SCOPE_IMPLEMENTATION.equals(this.getScope());
    }

    public String getApplication();

    public String getDetail();

    public static String composePackage(String pkg1, String pkg2) {
        if (pkg1 == null || pkg1.isEmpty()) {
            return pkg2;
        }
        if (pkg2 == null || pkg2.isEmpty()) {
            return pkg1;
        }
        return pkg1 + "." + pkg2;
    }
}

