/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.web.common.base;

import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToggleFilterWrapper
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ToggleFilterWrapper.class);
    private Filter delegateFilter;
    private Boolean enabled = Boolean.FALSE;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @PostConstruct
    public void initialize() {
        if (!this.enabled.booleanValue()) {
            String message = "****** FILTER " + this.delegateFilter + " HAS BEEN DISABLED! THIS FEATURE SHOULD ONLY BE USED IN DEVELOPMENT MODE ******";
            LOG.warn(message);
            System.err.println(message);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.enabled.booleanValue()) {
            this.delegateFilter.doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    public void setDelegateFilter(Filter delegateFilter) {
        this.delegateFilter = delegateFilter;
    }

    public void setEnabled(Boolean enabled) {
        if (enabled != null) {
            this.enabled = enabled;
        } else {
            LOG.warn(this.delegateFilter + " - ToggleFilterWrapper#setEnabled should not be set to NULL");
        }
    }

    public Boolean isEnabled() {
        return this.enabled;
    }
}

