/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.cxf.common.impl.client;

import com.devonfw.module.basic.common.api.config.ConfigProperties;
import com.devonfw.module.cxf.common.impl.client.interceptor.PerformanceStartInterceptor;
import com.devonfw.module.cxf.common.impl.client.interceptor.PerformanceStopInterceptor;
import com.devonfw.module.cxf.common.impl.client.interceptor.TechnicalExceptionInterceptor;
import com.devonfw.module.service.common.api.client.context.ServiceContext;
import com.devonfw.module.service.common.api.sync.SyncServiceClientFactory;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

public abstract class SyncServiceClientFactoryCxf
implements SyncServiceClientFactory {
    public <S> S create(ServiceContext<S> context) {
        boolean responsible = this.isResponsibleForService(context);
        if (!responsible) {
            return null;
        }
        String serviceName = this.createServiceName(context);
        String url = this.getUrl(context);
        S serviceClient = this.createService(context, url, serviceName);
        this.applyAspects(context, serviceClient, serviceName);
        return serviceClient;
    }

    protected abstract <S> S createService(ServiceContext<S> var1, String var2, String var3);

    protected String getUrl(ServiceContext<?> context) {
        String url = context.getUrl();
        url = url.replace("${type}", this.getServiceTypeFolderName());
        return url;
    }

    protected abstract <S> void applyAspects(ServiceContext<S> var1, S var2, String var3);

    protected abstract String getServiceTypeFolderName();

    protected HTTPClientPolicy createClientPolicy(ServiceContext<?> context) {
        ConfigProperties timeoutConfig = context.getConfig().getChild("timeout");
        if (!timeoutConfig.isEmpty()) {
            Long responseTimeout;
            HTTPClientPolicy policy = new HTTPClientPolicy();
            Long connectionTimeout = (Long)timeoutConfig.getChild("connection").getValue(Long.class);
            if (connectionTimeout != null) {
                policy.setConnectionTimeout(connectionTimeout.longValue());
            }
            if ((responseTimeout = (Long)timeoutConfig.getChild("response").getValue(Long.class)) != null) {
                policy.setReceiveTimeout(responseTimeout.longValue());
            }
            return policy;
        }
        return null;
    }

    protected String createServiceName(ServiceContext<?> context) {
        return context.getApi().getName();
    }

    protected void applyInterceptors(ServiceContext<?> context, InterceptorProvider client, String serviceName) {
        client.getOutInterceptors().add(new PerformanceStartInterceptor());
        client.getInInterceptors().add(new PerformanceStopInterceptor());
        client.getInFaultInterceptors().add(new TechnicalExceptionInterceptor(serviceName));
    }

    protected void applyClientPolicy(ServiceContext<?> context, HTTPConduit conduit) {
        if (conduit == null) {
            return;
        }
        HTTPClientPolicy clientPolicy = this.createClientPolicy(context);
        if (clientPolicy != null) {
            conduit.setClient(clientPolicy);
        }
    }

    protected abstract void applyHeaders(ServiceContext<?> var1, Object var2);

    protected abstract boolean isResponsibleForService(ServiceContext<?> var1);
}

