/*
 * Decompiled with CFR 0.152.
 */
package com.developer.bsince.log;

import android.text.TextUtils;
import android.util.Log;
import com.developer.bsince.log.ILog;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AndroidLogger
implements ILog.TagLog {
    private static final int MAX_LOG_LENGTH = 4000;
    private static final Pattern ANONYMOUS_CLASS = Pattern.compile("\\$\\d+$");
    private static final ThreadLocal<String> NEXT_TAG = new ThreadLocal();

    private static String createTag() {
        String tag = NEXT_TAG.get();
        if (tag != null) {
            NEXT_TAG.remove();
            return tag;
        }
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        if (stackTrace.length < 6) {
            throw new IllegalStateException("Synthetic stacktrace didn't have enough elements: are you using proguard?");
        }
        tag = stackTrace[5].getClassName();
        Matcher m = ANONYMOUS_CLASS.matcher(tag);
        if (m.find()) {
            tag = m.replaceAll("");
        }
        return tag.substring(tag.lastIndexOf(46) + 1);
    }

    static String formatString(String message, Object ... args) {
        return args.length == 0 ? message : String.format(message, args);
    }

    @Override
    public void v(String message, Object ... args) {
        this.printLog(2, AndroidLogger.formatString(message, args), null);
    }

    @Override
    public void v(Throwable t, String message, Object ... args) {
        this.printLog(2, AndroidLogger.formatString(message, args), t);
    }

    @Override
    public void d(String message, Object ... args) {
        this.printLog(3, AndroidLogger.formatString(message, args), null);
    }

    @Override
    public void d(Throwable t, String message, Object ... args) {
        this.printLog(3, AndroidLogger.formatString(message, args), t);
    }

    @Override
    public void i(String message, Object ... args) {
        this.printLog(4, AndroidLogger.formatString(message, args), null);
    }

    @Override
    public void i(Throwable t, String message, Object ... args) {
        this.printLog(4, AndroidLogger.formatString(message, args), t);
    }

    @Override
    public void w(String message, Object ... args) {
        this.printLog(5, AndroidLogger.formatString(message, args), null);
    }

    @Override
    public void w(Throwable t, String message, Object ... args) {
        this.printLog(5, AndroidLogger.formatString(message, args), t);
    }

    @Override
    public void e(String message, Object ... args) {
        this.printLog(6, AndroidLogger.formatString(message, args), null);
    }

    @Override
    public void wtf(String message, Object ... args) {
        this.printLog(7, AndroidLogger.formatString(message, args), null);
    }

    @Override
    public void e(Throwable t, String message, Object ... args) {
        this.printLog(6, AndroidLogger.formatString(message, args), t);
    }

    @Override
    public void json(String json) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.d("Empty/Null json content", new Object[0]);
            return;
        }
        try {
            if (json.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(json);
                String message = jsonObject.toString(4);
                this.d(message, new Object[0]);
                return;
            }
            if (json.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(json);
                String message = jsonArray.toString(4);
                this.d(message, new Object[0]);
            }
        }
        catch (JSONException e) {
            this.e(e.getCause().getMessage() + "\n" + json, new Object[0]);
        }
    }

    @Override
    public void xml(String xml) {
        if (TextUtils.isEmpty((CharSequence)xml)) {
            this.d("Empty/Null xml content", new Object[0]);
            return;
        }
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(xml));
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xmlInput, xmlOutput);
            this.d(xmlOutput.getWriter().toString().replaceFirst(">", ">\n"), new Object[0]);
        }
        catch (TransformerException e) {
            this.e(e.getCause().getMessage() + "\n" + xml, new Object[0]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void printLog(int priority, String message, Throwable t) {
        if (message == null || message.length() == 0) {
            if (t == null) return;
            message = Log.getStackTraceString((Throwable)t);
        } else if (t != null) {
            message = message + "\n" + Log.getStackTraceString((Throwable)t);
        }
        String tag = AndroidLogger.createTag();
        if (message.length() < 4000) {
            Log.println((int)priority, (String)tag, (String)message);
            return;
        }
        int length = message.length();
        for (int i = 0; i < length; ++i) {
            int end;
            int newline = message.indexOf(10, i);
            newline = newline != -1 ? newline : length;
            do {
                end = Math.min(newline, i + 4000);
                Log.println((int)priority, (String)tag, (String)message.substring(i, end));
            } while ((i = end) < newline);
        }
    }

    @Override
    public void tag(String tag) {
        NEXT_TAG.set(tag);
    }
}

