package com.devdigital.networklib.task;

import com.devdigital.networklib.listener.ErrorListener;
import com.devdigital.networklib.listener.ResponseListener;

import org.json.JSONObject;

/**
 * @author Dhaval Patel
 * @version 1.0
 * @since 7 April 2017
 */
public class StringTask<String> extends Task<String> {

    public Task addOnSuccessListener(ResponseListener<String> listener) {
        this.responseListener = listener;
        return this;
    }

    public Task addOnErrorListener(ErrorListener listener) {
        this.errorListener = listener;
        return this;
    }

    public ResponseListener<String> getResponseListener() {
        return responseListener;
    }

    public ErrorListener getErrorListener() {
        return errorListener;
    }
}
