/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.util;

import android.os.Build;
import com.devbrackets.android.exomedia.core.audio.AudioPlayerApi;
import com.devbrackets.android.exomedia.core.video.VideoPlayerApi;
import com.devbrackets.android.exomedia.core.video.surface.SurfaceEnvelope;
import com.devbrackets.android.exomedia.fallback.audio.NativeAudioPlayer;
import com.devbrackets.android.exomedia.fallback.video.NativeVideoPlayer;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfig;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/devbrackets/android/exomedia/util/FallbackManager;", "", "<init>", "()V", "incompatibleDevices", "", "", "Lcom/devbrackets/android/exomedia/util/FallbackManager$DeviceModels;", "useFallback", "", "getFallbackAudioPlayer", "Lcom/devbrackets/android/exomedia/core/audio/AudioPlayerApi;", "config", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "getFallbackVideoPlayer", "Lcom/devbrackets/android/exomedia/core/video/VideoPlayerApi;", "surface", "Lcom/devbrackets/android/exomedia/core/video/surface/SurfaceEnvelope;", "DeviceModels", "library_release"})
public class FallbackManager {
    @NotNull
    private final Map<String, DeviceModels> incompatibleDevices = MapsKt.mapOf((Pair)TuplesKt.to((Object)"amazon", (Object)new DeviceModels(null, true, 1, null)));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean useFallback() {
        String string2 = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MANUFACTURER");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        DeviceModels deviceModels = this.incompatibleDevices.get(string3);
        if (deviceModels == null) return false;
        DeviceModels it = deviceModels;
        boolean bl = false;
        if (it.getAllModels()) return true;
        Set<String> set = it.getModels();
        String string4 = Build.DEVICE;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"DEVICE");
        String string5 = string4.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        if (!set.contains(string5)) return false;
        return true;
    }

    @NotNull
    public AudioPlayerApi getFallbackAudioPlayer(@NotNull PlayerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return new NativeAudioPlayer(config);
    }

    @NotNull
    public VideoPlayerApi getFallbackVideoPlayer(@NotNull PlayerConfig config, @NotNull SurfaceEnvelope surface) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        return new NativeVideoPlayer(config, surface);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/devbrackets/android/exomedia/util/FallbackManager$DeviceModels;", "", "models", "", "", "allModels", "", "<init>", "(Ljava/util/Set;Z)V", "getModels", "()Ljava/util/Set;", "getAllModels", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "library_release"})
    public static final class DeviceModels {
        @NotNull
        private final Set<String> models;
        private final boolean allModels;

        public DeviceModels(@NotNull Set<String> models, boolean allModels) {
            Intrinsics.checkNotNullParameter(models, (String)"models");
            this.models = models;
            this.allModels = allModels;
        }

        public /* synthetic */ DeviceModels(Set set, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                set = SetsKt.emptySet();
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            this(set, bl);
        }

        @NotNull
        public final Set<String> getModels() {
            return this.models;
        }

        public final boolean getAllModels() {
            return this.allModels;
        }

        @NotNull
        public final Set<String> component1() {
            return this.models;
        }

        public final boolean component2() {
            return this.allModels;
        }

        @NotNull
        public final DeviceModels copy(@NotNull Set<String> models, boolean allModels) {
            Intrinsics.checkNotNullParameter(models, (String)"models");
            return new DeviceModels(models, allModels);
        }

        public static /* synthetic */ DeviceModels copy$default(DeviceModels deviceModels, Set set, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                set = deviceModels.models;
            }
            if ((n & 2) != 0) {
                bl = deviceModels.allModels;
            }
            return deviceModels.copy(set, bl);
        }

        @NotNull
        public String toString() {
            return "DeviceModels(models=" + this.models + ", allModels=" + this.allModels + ")";
        }

        public int hashCode() {
            int result = ((Object)this.models).hashCode();
            result = result * 31 + Boolean.hashCode(this.allModels);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeviceModels)) {
                return false;
            }
            DeviceModels deviceModels = (DeviceModels)other;
            if (!Intrinsics.areEqual(this.models, deviceModels.models)) {
                return false;
            }
            return this.allModels == deviceModels.allModels;
        }

        public DeviceModels() {
            this(null, false, 3, null);
        }
    }
}

