/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.ui.widget.controls;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import com.devbrackets.android.exomedia.R;
import com.devbrackets.android.exomedia.ui.listener.VideoControlsButtonListener;
import com.devbrackets.android.exomedia.ui.listener.VideoControlsSeekListener;
import com.devbrackets.android.exomedia.ui.widget.VideoView;
import com.devbrackets.android.exomedia.ui.widget.controls.DefaultVideoControls;
import com.devbrackets.android.exomedia.util.view.DelegatedOnKeyListener;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 92\u00020\u0001:\b9:;<=>?@B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\u000bB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\rJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\b\u0010\u001f\u001a\u00020\u001eH\u0014J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0013H\u0016J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0013H\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u0013H\u0016J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u0013H\u0016J\b\u0010&\u001a\u00020\u001eH\u0014J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001aH\u0016J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001aH\u0016J\b\u0010*\u001a\u00020\u001eH\u0016J\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\u0013H\u0014J\u0010\u00100\u001a\u00020\u001e2\u0006\u00101\u001a\u000202H\u0016J\u0012\u00103\u001a\u00020\u001e2\b\u00101\u001a\u0004\u0018\u000102H\u0016J\b\u00104\u001a\u00020\u001eH\u0002J\b\u00105\u001a\u00020\u001eH\u0002J\u0010\u00106\u001a\u00020\u001e2\u0006\u00107\u001a\u00020-H\u0002J\b\u00108\u001a\u00020\u001eH\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006A"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsTv;", "Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "extraViewsContainer", "Landroid/widget/LinearLayout;", "container", "Landroid/view/ViewGroup;", "rewindEnabled", "", "fastForwardEnabled", "layoutResource", "getLayoutResource", "()I", "extraViews", "", "Landroid/view/View;", "getExtraViews", "()Ljava/util/List;", "setup", "", "retrieveViews", "setRewindButtonEnabled", "enabled", "setFastForwardButtonEnabled", "setRewindButtonRemoved", "removed", "setFastForwardButtonRemoved", "registerListeners", "addExtraView", "view", "removeExtraView", "show", "hideDelayed", "delay", "", "animateVisibility", "toVisible", "onLoadStarted", "state", "Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$LoadState;", "onLoadEnded", "onRewindClick", "onFastForwardClick", "performSeek", "seekToTime", "registerForInput", "Companion", "SeekBarChanged", "InteractionKeyListener", "HiddenKeyListener", "SeekKeyListener", "MediaKeyListener", "OnKeyHierarchyListener", "TvInternalListener", "library_release"})
public final class VideoControlsTv
extends DefaultVideoControls {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private LinearLayout extraViewsContainer;
    private ViewGroup container;
    private boolean rewindEnabled;
    private boolean fastForwardEnabled;
    private static final long FAST_FORWARD_REWIND_AMOUNT = 10000L;
    private static final long TV_CONTROLS_HIDE_DELAY = 5000L;

    @Override
    protected int getLayoutResource() {
        return R.layout.exomedia_controls_tv;
    }

    @Override
    @NotNull
    public List<View> getExtraViews() {
        int childCount;
        LinearLayout linearLayout = this.extraViewsContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extraViewsContainer");
            linearLayout = null;
        }
        if ((childCount = linearLayout.getChildCount()) <= 0) {
            return super.getExtraViews();
        }
        LinkedList<View> children = new LinkedList<View>();
        for (int i = 0; i < childCount; ++i) {
            LinearLayout linearLayout2 = this.extraViewsContainer;
            if (linearLayout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"extraViewsContainer");
                linearLayout2 = null;
            }
            children.add(linearLayout2.getChildAt(i));
        }
        return children;
    }

    public VideoControlsTv(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.rewindEnabled = true;
        this.fastForwardEnabled = true;
    }

    public VideoControlsTv(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.rewindEnabled = true;
        this.fastForwardEnabled = true;
    }

    public VideoControlsTv(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.rewindEnabled = true;
        this.fastForwardEnabled = true;
    }

    public VideoControlsTv(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.rewindEnabled = true;
        this.fastForwardEnabled = true;
    }

    @Override
    protected void setup(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.setup(context);
        this.setDefaultHideDelay(5000L);
        this.setInternalListener(new TvInternalListener());
        this.registerForInput();
    }

    @Override
    protected void retrieveViews() {
        super.retrieveViews();
        this.extraViewsContainer = (LinearLayout)this.findViewById(R.id.exomedia_controls_extra_container);
        this.container = (ViewGroup)this.findViewById(R.id.exomedia_controls_container);
    }

    @Override
    public void setRewindButtonEnabled(boolean enabled) {
        this.rewindEnabled = enabled;
    }

    @Override
    public void setFastForwardButtonEnabled(boolean enabled) {
        this.fastForwardEnabled = enabled;
    }

    @Override
    public void setRewindButtonRemoved(boolean removed) {
    }

    @Override
    public void setFastForwardButtonRemoved(boolean removed) {
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.getSeekBar().setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)new SeekBarChanged());
    }

    @Override
    public void addExtraView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        LinearLayout linearLayout = this.extraViewsContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extraViewsContainer");
            linearLayout = null;
        }
        linearLayout.addView(view);
    }

    @Override
    public void removeExtraView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        LinearLayout linearLayout = this.extraViewsContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extraViewsContainer");
            linearLayout = null;
        }
        linearLayout.removeView(view);
    }

    @Override
    public void show() {
        super.show();
        VideoView videoView = this.getVideoView();
        boolean bl = videoView != null ? videoView.isPlaying() : false;
        if (bl) {
            this.hide(true);
        }
    }

    @Override
    public void hideDelayed(long delay) {
        if (delay < 0L || this.getCurrentLoadState() != null) {
            return;
        }
        if (!this.getUserInteracting()) {
            this.getVisibilityHandler().postDelayed(() -> VideoControlsTv.hideDelayed$lambda$0(this), delay);
        }
    }

    @Override
    protected void animateVisibility(boolean toVisible) {
        if (this.isVisible() == toVisible) {
            return;
        }
        float endAlpha = toVisible ? 1.0f : 0.0f;
        ViewGroup viewGroup = this.container;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
            viewGroup = null;
        }
        viewGroup.animate().alpha(endAlpha).start();
        this.setVisible(toVisible);
        this.onVisibilityChanged();
    }

    @Override
    public void onLoadStarted(@NotNull DefaultVideoControls.LoadState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.getLoadingProgressBar().setVisibility(0);
        this.getPlayPauseButton().setVisibility(4);
        if (state == DefaultVideoControls.LoadState.PREPARING) {
            this.getSeekBar().setVisibility(4);
            this.getCurrentTimeTextView().setVisibility(4);
            this.getTimeSeparatorView().setVisibility(4);
            this.getEndTimeTextView().setVisibility(4);
            this.getPreviousButton().setVisibility(4);
            this.getNextButton().setVisibility(4);
            LinearLayout linearLayout = this.extraViewsContainer;
            if (linearLayout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"extraViewsContainer");
                linearLayout = null;
            }
            linearLayout.setVisibility(4);
        }
        this.show();
    }

    @Override
    public void onLoadEnded(@Nullable DefaultVideoControls.LoadState state) {
        this.setCurrentLoadState(null);
        this.getLoadingProgressBar().setVisibility(8);
        this.getSeekBar().setVisibility(0);
        ViewGroup viewGroup = this.container;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
            viewGroup = null;
        }
        viewGroup.setVisibility(0);
        this.getCurrentTimeTextView().setVisibility(0);
        this.getTimeSeparatorView().setVisibility(0);
        this.getEndTimeTextView().setVisibility(0);
        this.getPlayPauseButton().setVisibility(0);
        this.getPlayPauseButton().setEnabled(true);
        this.getPreviousButton().setVisibility(this.getConfiguration().visibility(R.id.exomedia_controls_previous_btn));
        this.getPreviousButton().setEnabled(this.getConfiguration().isEnabled(R.id.exomedia_controls_previous_btn));
        this.getNextButton().setVisibility(this.getConfiguration().visibility(R.id.exomedia_controls_next_btn));
        this.getNextButton().setEnabled(this.getConfiguration().isEnabled(R.id.exomedia_controls_next_btn));
        LinearLayout linearLayout = this.extraViewsContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extraViewsContainer");
            linearLayout = null;
        }
        linearLayout.setVisibility(0);
        VideoView videoView = this.getVideoView();
        this.updatePlaybackState(videoView != null ? videoView.isPlaying() : false);
        if (state == DefaultVideoControls.LoadState.PREPARING) {
            this.getSeekBar().requestFocus();
        }
    }

    private final void onRewindClick() {
        if (this.rewindEnabled) {
            VideoControlsButtonListener videoControlsButtonListener = this.getButtonsListener();
            if (!(videoControlsButtonListener != null ? videoControlsButtonListener.onRewindClicked() : false)) {
                this.getInternalListener().onRewindClicked();
            }
        }
    }

    private final void onFastForwardClick() {
        if (this.fastForwardEnabled) {
            VideoControlsButtonListener videoControlsButtonListener = this.getButtonsListener();
            if (!(videoControlsButtonListener != null ? videoControlsButtonListener.onFastForwardClicked() : false)) {
                this.getInternalListener().onFastForwardClicked();
            }
        }
    }

    private final void performSeek(long seekToTime) {
        VideoControlsSeekListener videoControlsSeekListener = this.getSeekListener();
        if (!(videoControlsSeekListener != null ? videoControlsSeekListener.onSeekEnded(seekToTime) : false)) {
            this.show();
            this.getInternalListener().onSeekEnded(seekToTime);
        }
    }

    private final void registerForInput() {
        DelegatedOnKeyListener delegatedOnKeyListener;
        DelegatedOnKeyListener $this$registerForInput_u24lambda_u241 = delegatedOnKeyListener = new DelegatedOnKeyListener();
        boolean bl = false;
        $this$registerForInput_u24lambda_u241.register(new HiddenKeyListener());
        $this$registerForInput_u24lambda_u241.register(new InteractionKeyListener());
        $this$registerForInput_u24lambda_u241.register(new SeekKeyListener());
        $this$registerForInput_u24lambda_u241.register(new MediaKeyListener());
        DelegatedOnKeyListener delegatedOnKeyListener2 = delegatedOnKeyListener;
        OnKeyHierarchyListener hierarchyListener = new OnKeyHierarchyListener(delegatedOnKeyListener2);
        ViewGroup viewGroup = this.container;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
            viewGroup = null;
        }
        hierarchyListener.setForViewGroup(viewGroup);
        LinearLayout linearLayout = this.extraViewsContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extraViewsContainer");
            linearLayout = null;
        }
        hierarchyListener.setForViewGroup((ViewGroup)linearLayout);
    }

    private static final void hideDelayed$lambda$0(VideoControlsTv this$0) {
        this$0.animateVisibility(false);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsTv$Companion;", "", "<init>", "()V", "FAST_FORWARD_REWIND_AMOUNT", "", "TV_CONTROLS_HIDE_DELAY", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsTv$HiddenKeyListener;", "Landroid/view/View$OnKeyListener;", "<init>", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsTv;)V", "onKey", "", "v", "Landroid/view/View;", "keyCode", "", "event", "Landroid/view/KeyEvent;", "library_release"})
    private final class HiddenKeyListener
    implements View.OnKeyListener {
        public boolean onKey(@Nullable View v, int keyCode, @Nullable KeyEvent event) {
            boolean bl;
            if (VideoControlsTv.this.isVisible() || event == null || event.getAction() != 1) {
                return false;
            }
            switch (keyCode) {
                case 23: 
                case 85: {
                    VideoControlsTv.this.onPlayPauseClick();
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsTv$InteractionKeyListener;", "Landroid/view/View$OnKeyListener;", "<init>", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsTv;)V", "onKey", "", "v", "Landroid/view/View;", "keyCode", "", "event", "Landroid/view/KeyEvent;", "library_release"})
    private final class InteractionKeyListener
    implements View.OnKeyListener {
        public boolean onKey(@Nullable View v, int keyCode, @Nullable KeyEvent event) {
            if (event == null || event.getAction() != 1) {
                return false;
            }
            switch (keyCode) {
                case 4: 
                case 30: 
                case 111: 
                case 263: {
                    if (!VideoControlsTv.this.isVisible() || VideoControlsTv.this.getCurrentLoadState() != null) break;
                    VideoControlsTv.this.hide();
                    return true;
                }
                default: {
                    VideoControlsTv.this.show();
                }
            }
            return false;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsTv$MediaKeyListener;", "Landroid/view/View$OnKeyListener;", "<init>", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsTv;)V", "onKey", "", "v", "Landroid/view/View;", "keyCode", "", "event", "Landroid/view/KeyEvent;", "library_release"})
    private final class MediaKeyListener
    implements View.OnKeyListener {
        public boolean onKey(@Nullable View v, int keyCode, @Nullable KeyEvent event) {
            if (event == null || event.getAction() != 1) {
                return false;
            }
            switch (keyCode) {
                case 85: {
                    VideoControlsTv.this.onPlayPauseClick();
                    return true;
                }
                case 126: {
                    VideoControlsTv.this.onPlayClick();
                    return true;
                }
                case 127: {
                    VideoControlsTv.this.onPauseClick();
                    return true;
                }
                case 87: 
                case 103: {
                    VideoControlsTv.this.onNextClick();
                    return true;
                }
                case 88: 
                case 102: {
                    VideoControlsTv.this.onPreviousClick();
                    return true;
                }
                case 89: 
                case 104: {
                    VideoControlsTv.this.onRewindClick();
                    return true;
                }
                case 90: 
                case 105: {
                    VideoControlsTv.this.onFastForwardClick();
                    return true;
                }
            }
            return false;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0016J\u001c\u0010\u000b\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0016J\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsTv$OnKeyHierarchyListener;", "Landroid/view/ViewGroup$OnHierarchyChangeListener;", "onKeyListener", "Landroid/view/View$OnKeyListener;", "<init>", "(Landroid/view/View$OnKeyListener;)V", "onChildViewAdded", "", "parent", "Landroid/view/View;", "child", "onChildViewRemoved", "setForViewGroup", "viewGroup", "Landroid/view/ViewGroup;", "library_release"})
    @SourceDebugExtension(value={"SMAP\nVideoControlsTv.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoControlsTv.kt\ncom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsTv$OnKeyHierarchyListener\n+ 2 ViewGroup.kt\nandroidx/core/view/ViewGroupKt\n*L\n1#1,454:1\n53#2,4:455\n*S KotlinDebug\n*F\n+ 1 VideoControlsTv.kt\ncom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsTv$OnKeyHierarchyListener\n*L\n426#1:455,4\n*E\n"})
    private static final class OnKeyHierarchyListener
    implements ViewGroup.OnHierarchyChangeListener {
        @NotNull
        private final View.OnKeyListener onKeyListener;

        public OnKeyHierarchyListener(@NotNull View.OnKeyListener onKeyListener) {
            Intrinsics.checkNotNullParameter((Object)onKeyListener, (String)"onKeyListener");
            this.onKeyListener = onKeyListener;
        }

        public void onChildViewAdded(@Nullable View parent, @Nullable View child) {
            View view = child;
            boolean bl = view != null ? view.isFocusable() : false;
            if (bl) {
                child.setOnKeyListener(this.onKeyListener);
            }
        }

        public void onChildViewRemoved(@Nullable View parent, @Nullable View child) {
        }

        public final void setForViewGroup(@NotNull ViewGroup viewGroup) {
            Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
            viewGroup.setOnHierarchyChangeListener((ViewGroup.OnHierarchyChangeListener)this);
            ViewGroup $this$forEach$iv = viewGroup;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.getChildCount();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                View child = $this$forEach$iv.getChildAt(index$iv);
                boolean bl = false;
                this.onChildViewAdded((View)viewGroup, child);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsTv$SeekBarChanged;", "Landroid/widget/SeekBar$OnSeekBarChangeListener;", "<init>", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsTv;)V", "seekToTime", "", "onProgressChanged", "", "seekBar", "Landroid/widget/SeekBar;", "progress", "", "fromUser", "", "onStartTrackingTouch", "onStopTrackingTouch", "library_release"})
    private final class SeekBarChanged
    implements SeekBar.OnSeekBarChangeListener {
        private long seekToTime;

        public void onProgressChanged(@NotNull SeekBar seekBar, int progress, boolean fromUser) {
            Intrinsics.checkNotNullParameter((Object)seekBar, (String)"seekBar");
            if (!fromUser) {
                return;
            }
            this.seekToTime = progress;
        }

        public void onStartTrackingTouch(@NotNull SeekBar seekBar) {
            Intrinsics.checkNotNullParameter((Object)seekBar, (String)"seekBar");
            VideoControlsTv.this.setUserInteracting(true);
            VideoControlsSeekListener videoControlsSeekListener = VideoControlsTv.this.getSeekListener();
            if (!(videoControlsSeekListener != null ? videoControlsSeekListener.onSeekStarted() : false)) {
                VideoControlsTv.this.getInternalListener().onSeekStarted();
            }
        }

        public void onStopTrackingTouch(@NotNull SeekBar seekBar) {
            Intrinsics.checkNotNullParameter((Object)seekBar, (String)"seekBar");
            VideoControlsTv.this.setUserInteracting(false);
            VideoControlsSeekListener videoControlsSeekListener = VideoControlsTv.this.getSeekListener();
            if (!(videoControlsSeekListener != null ? videoControlsSeekListener.onSeekEnded(this.seekToTime) : false)) {
                VideoControlsTv.this.getInternalListener().onSeekEnded(this.seekToTime);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsTv$SeekKeyListener;", "Landroid/view/View$OnKeyListener;", "<init>", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsTv;)V", "onKey", "", "v", "Landroid/view/View;", "keyCode", "", "event", "Landroid/view/KeyEvent;", "library_release"})
    private final class SeekKeyListener
    implements View.OnKeyListener {
        public boolean onKey(@Nullable View v, int keyCode, @Nullable KeyEvent event) {
            boolean bl;
            if (!Intrinsics.areEqual((Object)v, (Object)VideoControlsTv.this.getSeekBar()) || event == null || event.getAction() != 1) {
                return false;
            }
            switch (keyCode) {
                case 23: {
                    VideoControlsTv.this.onPlayPauseClick();
                    bl = true;
                    break;
                }
                case 22: {
                    VideoControlsTv.this.onFastForwardClick();
                    bl = true;
                    break;
                }
                case 21: {
                    VideoControlsTv.this.onRewindClick();
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsTv$TvInternalListener;", "Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$InternalListener;", "Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls;", "<init>", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsTv;)V", "onFastForwardClicked", "", "onRewindClicked", "seekBy", "amountMillis", "", "library_release"})
    private final class TvInternalListener
    extends DefaultVideoControls.InternalListener {
        @Override
        public boolean onFastForwardClicked() {
            return this.seekBy(10000L);
        }

        @Override
        public boolean onRewindClicked() {
            return this.seekBy(-10000L);
        }

        private final boolean seekBy(long amountMillis) {
            VideoView view = VideoControlsTv.this.getVideoView();
            if (view == null || !view.isAttachedToWindow()) {
                return false;
            }
            long position = RangesKt.coerceIn((long)(view.getCurrentPosition() + amountMillis), (long)0L, (long)VideoControlsTv.this.getSeekBar().getMax());
            VideoControlsTv.this.performSeek(position);
            return true;
        }
    }
}

