/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import androidx.annotation.FloatRange;
import com.devbrackets.android.exomedia.util.StopWatch;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 52\u00020\u0001:\u000256B\u0011\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u00101\u001a\u00020&2\u0006\u0010-\u001a\u00020\tJ\u0006\u00102\u001a\u00020&J\u0006\u00103\u001a\u00020&J\u0006\u00104\u001a\u00020&R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R7\u0010\"\u001a\u001f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020&\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0012\u0010+\u001a\u00060,R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010-\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u000e\u00100\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/devbrackets/android/exomedia/util/StopWatch;", "", "processOnStartingThread", "", "(Z)V", "handler", "Landroid/os/Handler;", "(Landroid/os/Handler;)V", "currentTime", "", "delayedHandler", "handlerThread", "Landroid/os/HandlerThread;", "getHandlerThread", "()Landroid/os/HandlerThread;", "handlerThread$delegate", "Lkotlin/Lazy;", "<set-?>", "isRunning", "()Z", "speedMultiplier", "", "getSpeedMultiplier", "()F", "setSpeedMultiplier", "(F)V", "startTime", "storedTime", "tickDelay", "", "getTickDelay", "()I", "setTickDelay", "(I)V", "tickListener", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "", "getTickListener", "()Lkotlin/jvm/functions/Function1;", "setTickListener", "(Lkotlin/jvm/functions/Function1;)V", "tickRunnable", "Lcom/devbrackets/android/exomedia/util/StopWatch$TickRunnable;", "time", "getTime", "()J", "useHandlerThread", "overrideCurrentTime", "reset", "start", "stop", "Companion", "TickRunnable", "library_release"})
public final class StopWatch {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private volatile boolean isRunning;
    private int tickDelay;
    @Nullable
    private Handler delayedHandler;
    @NotNull
    private final Lazy handlerThread$delegate;
    private boolean useHandlerThread;
    @Nullable
    private Function1<? super Long, Unit> tickListener;
    @NotNull
    private TickRunnable tickRunnable;
    private long startTime;
    private long currentTime;
    private long storedTime;
    @FloatRange(from=0.0)
    private float speedMultiplier;
    @NotNull
    private static final String HANDLER_THREAD_NAME = "ExoMedia_StopWatch_HandlerThread";
    private static final int DEFAULT_TICK_DELAY = 33;

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final int getTickDelay() {
        return this.tickDelay;
    }

    public final void setTickDelay(int n) {
        this.tickDelay = n;
    }

    private final HandlerThread getHandlerThread() {
        Lazy lazy = this.handlerThread$delegate;
        return (HandlerThread)lazy.getValue();
    }

    @Nullable
    public final Function1<Long, Unit> getTickListener() {
        return this.tickListener;
    }

    public final void setTickListener(@Nullable Function1<? super Long, Unit> function1) {
        this.tickListener = function1;
    }

    public final float getSpeedMultiplier() {
        return this.speedMultiplier;
    }

    public final void setSpeedMultiplier(float f) {
        this.speedMultiplier = f;
    }

    public final long getTime() {
        return this.currentTime + this.storedTime;
    }

    @JvmOverloads
    public StopWatch(boolean processOnStartingThread) {
        this.tickDelay = 33;
        this.handlerThread$delegate = LazyKt.lazy((Function0)handlerThread.2.INSTANCE);
        this.tickRunnable = new TickRunnable();
        this.speedMultiplier = 1.0f;
        if (processOnStartingThread) {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                looper = Looper.getMainLooper();
            }
            this.delayedHandler = new Handler(looper);
            return;
        }
        this.useHandlerThread = true;
    }

    public /* synthetic */ StopWatch(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public StopWatch(@NotNull Handler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.tickDelay = 33;
        this.handlerThread$delegate = LazyKt.lazy((Function0)handlerThread.2.INSTANCE);
        this.tickRunnable = new TickRunnable();
        this.speedMultiplier = 1.0f;
        this.delayedHandler = handler;
    }

    public final void start() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.startTime = System.currentTimeMillis();
        this.tickRunnable.setLastTickTimestamp(this.startTime);
        if (this.useHandlerThread) {
            this.getHandlerThread().start();
            this.delayedHandler = new Handler(this.getHandlerThread().getLooper());
        }
        this.tickRunnable.performTick();
    }

    public final void stop() {
        if (!this.isRunning) {
            return;
        }
        Handler handler = this.delayedHandler;
        if (handler != null) {
            handler.removeCallbacksAndMessages(null);
        }
        this.getHandlerThread().quit();
        this.storedTime += this.currentTime;
        this.isRunning = false;
        this.currentTime = 0L;
    }

    public final void reset() {
        this.currentTime = 0L;
        this.storedTime = 0L;
        this.startTime = System.currentTimeMillis();
        this.tickRunnable.setLastTickTimestamp(this.startTime);
    }

    public final void overrideCurrentTime(long time) {
        this.startTime = System.currentTimeMillis();
        this.tickRunnable.setLastTickTimestamp(this.startTime);
        this.currentTime = 0L;
        this.storedTime = time;
    }

    @JvmOverloads
    public StopWatch() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/devbrackets/android/exomedia/util/StopWatch$Companion;", "", "()V", "DEFAULT_TICK_DELAY", "", "HANDLER_THREAD_NAME", "", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u000bH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/devbrackets/android/exomedia/util/StopWatch$TickRunnable;", "Ljava/lang/Runnable;", "(Lcom/devbrackets/android/exomedia/util/StopWatch;)V", "lastTickTimestamp", "", "getLastTickTimestamp", "()J", "setLastTickTimestamp", "(J)V", "tempNow", "performTick", "", "run", "library_release"})
    private final class TickRunnable
    implements Runnable {
        private long tempNow;
        private long lastTickTimestamp = -1L;

        public final long getLastTickTimestamp() {
            return this.lastTickTimestamp;
        }

        public final void setLastTickTimestamp(long l) {
            this.lastTickTimestamp = l;
        }

        @Override
        public void run() {
            block2: {
                if (this.lastTickTimestamp == -1L) {
                    this.lastTickTimestamp = StopWatch.this.startTime;
                }
                this.tempNow = System.currentTimeMillis();
                StopWatch stopWatch = StopWatch.this;
                stopWatch.currentTime = stopWatch.currentTime + (long)((float)(this.tempNow - this.lastTickTimestamp) * StopWatch.this.getSpeedMultiplier());
                this.lastTickTimestamp = this.tempNow;
                if (StopWatch.this.isRunning()) {
                    this.performTick();
                }
                Function1<Long, Unit> function1 = StopWatch.this.getTickListener();
                if (function1 == null) break block2;
                function1.invoke((Object)(StopWatch.this.currentTime + StopWatch.this.storedTime));
            }
        }

        public final void performTick() {
            block0: {
                Handler handler = StopWatch.this.delayedHandler;
                if (handler == null) break block0;
                handler.postDelayed((Runnable)StopWatch.this.tickRunnable, (long)StopWatch.this.getTickDelay());
            }
        }
    }
}

