/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.source.builder;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import androidx.annotation.OptIn;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DefaultDataSource;
import androidx.media3.datasource.TransferListener;
import androidx.media3.exoplayer.drm.DefaultDrmSessionManagerProvider;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.source.MediaSource;
import com.devbrackets.android.exomedia.core.source.data.DataSourceFactoryProvider;
import com.devbrackets.android.exomedia.core.source.data.DefaultDataSourceFactoryProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lcom/devbrackets/android/exomedia/core/source/builder/MediaSourceBuilder;", "", "()V", "build", "Landroidx/media3/exoplayer/source/MediaSource;", "attributes", "Lcom/devbrackets/android/exomedia/core/source/builder/MediaSourceBuilder$MediaSourceAttributes;", "buildDataSourceFactory", "Landroidx/media3/datasource/DataSource$Factory;", "MediaSourceAttributes", "library_release"})
@OptIn(markerClass={UnstableApi.class})
public abstract class MediaSourceBuilder {
    @NotNull
    public abstract MediaSource build(@NotNull MediaSourceAttributes var1);

    @NotNull
    public final DataSource.Factory buildDataSourceFactory(@NotNull MediaSourceAttributes attributes) {
        DefaultDataSource.Factory factory;
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        DataSource.Factory dataSourceFactory = attributes.getDataSourceFactoryProvider().provide(attributes.getUserAgent(), attributes.getTransferListener());
        DefaultDataSource.Factory $this$buildDataSourceFactory_u24lambda_u240 = factory = new DefaultDataSource.Factory(attributes.getContext(), dataSourceFactory);
        boolean bl = false;
        $this$buildDataSourceFactory_u24lambda_u240.setTransferListener(attributes.getTransferListener());
        return (DataSource.Factory)factory;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010$\u001a\u00020\rH\u00c6\u0003J\t\u0010%\u001a\u00020\u000fH\u00c6\u0003JQ\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006-"}, d2={"Lcom/devbrackets/android/exomedia/core/source/builder/MediaSourceBuilder$MediaSourceAttributes;", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "handler", "Landroid/os/Handler;", "userAgent", "", "transferListener", "Landroidx/media3/datasource/TransferListener;", "drmSessionManagerProvider", "Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "dataSourceFactoryProvider", "Lcom/devbrackets/android/exomedia/core/source/data/DataSourceFactoryProvider;", "(Landroid/content/Context;Landroid/net/Uri;Landroid/os/Handler;Ljava/lang/String;Landroidx/media3/datasource/TransferListener;Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;Lcom/devbrackets/android/exomedia/core/source/data/DataSourceFactoryProvider;)V", "getContext", "()Landroid/content/Context;", "getDataSourceFactoryProvider", "()Lcom/devbrackets/android/exomedia/core/source/data/DataSourceFactoryProvider;", "getDrmSessionManagerProvider", "()Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "getHandler", "()Landroid/os/Handler;", "getTransferListener", "()Landroidx/media3/datasource/TransferListener;", "getUri", "()Landroid/net/Uri;", "getUserAgent", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "library_release"})
    public static final class MediaSourceAttributes {
        @NotNull
        private final Context context;
        @NotNull
        private final Uri uri;
        @NotNull
        private final Handler handler;
        @NotNull
        private final String userAgent;
        @Nullable
        private final TransferListener transferListener;
        @NotNull
        private final DrmSessionManagerProvider drmSessionManagerProvider;
        @NotNull
        private final DataSourceFactoryProvider dataSourceFactoryProvider;

        public MediaSourceAttributes(@NotNull Context context, @NotNull Uri uri, @NotNull Handler handler, @NotNull String userAgent, @Nullable TransferListener transferListener, @NotNull DrmSessionManagerProvider drmSessionManagerProvider, @NotNull DataSourceFactoryProvider dataSourceFactoryProvider) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
            Intrinsics.checkNotNullParameter((Object)drmSessionManagerProvider, (String)"drmSessionManagerProvider");
            Intrinsics.checkNotNullParameter((Object)dataSourceFactoryProvider, (String)"dataSourceFactoryProvider");
            this.context = context;
            this.uri = uri;
            this.handler = handler;
            this.userAgent = userAgent;
            this.transferListener = transferListener;
            this.drmSessionManagerProvider = drmSessionManagerProvider;
            this.dataSourceFactoryProvider = dataSourceFactoryProvider;
        }

        public /* synthetic */ MediaSourceAttributes(Context context, Uri uri, Handler handler, String string, TransferListener transferListener, DrmSessionManagerProvider drmSessionManagerProvider, DataSourceFactoryProvider dataSourceFactoryProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                transferListener = null;
            }
            if ((n & 0x20) != 0) {
                drmSessionManagerProvider = (DrmSessionManagerProvider)new DefaultDrmSessionManagerProvider();
            }
            if ((n & 0x40) != 0) {
                dataSourceFactoryProvider = new DefaultDataSourceFactoryProvider();
            }
            this(context, uri, handler, string, transferListener, drmSessionManagerProvider, dataSourceFactoryProvider);
        }

        @NotNull
        public final Context getContext() {
            return this.context;
        }

        @NotNull
        public final Uri getUri() {
            return this.uri;
        }

        @NotNull
        public final Handler getHandler() {
            return this.handler;
        }

        @NotNull
        public final String getUserAgent() {
            return this.userAgent;
        }

        @Nullable
        public final TransferListener getTransferListener() {
            return this.transferListener;
        }

        @NotNull
        public final DrmSessionManagerProvider getDrmSessionManagerProvider() {
            return this.drmSessionManagerProvider;
        }

        @NotNull
        public final DataSourceFactoryProvider getDataSourceFactoryProvider() {
            return this.dataSourceFactoryProvider;
        }

        @NotNull
        public final Context component1() {
            return this.context;
        }

        @NotNull
        public final Uri component2() {
            return this.uri;
        }

        @NotNull
        public final Handler component3() {
            return this.handler;
        }

        @NotNull
        public final String component4() {
            return this.userAgent;
        }

        @Nullable
        public final TransferListener component5() {
            return this.transferListener;
        }

        @NotNull
        public final DrmSessionManagerProvider component6() {
            return this.drmSessionManagerProvider;
        }

        @NotNull
        public final DataSourceFactoryProvider component7() {
            return this.dataSourceFactoryProvider;
        }

        @NotNull
        public final MediaSourceAttributes copy(@NotNull Context context, @NotNull Uri uri, @NotNull Handler handler, @NotNull String userAgent, @Nullable TransferListener transferListener, @NotNull DrmSessionManagerProvider drmSessionManagerProvider, @NotNull DataSourceFactoryProvider dataSourceFactoryProvider) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
            Intrinsics.checkNotNullParameter((Object)drmSessionManagerProvider, (String)"drmSessionManagerProvider");
            Intrinsics.checkNotNullParameter((Object)dataSourceFactoryProvider, (String)"dataSourceFactoryProvider");
            return new MediaSourceAttributes(context, uri, handler, userAgent, transferListener, drmSessionManagerProvider, dataSourceFactoryProvider);
        }

        public static /* synthetic */ MediaSourceAttributes copy$default(MediaSourceAttributes mediaSourceAttributes, Context context, Uri uri, Handler handler, String string, TransferListener transferListener, DrmSessionManagerProvider drmSessionManagerProvider, DataSourceFactoryProvider dataSourceFactoryProvider, int n, Object object) {
            if ((n & 1) != 0) {
                context = mediaSourceAttributes.context;
            }
            if ((n & 2) != 0) {
                uri = mediaSourceAttributes.uri;
            }
            if ((n & 4) != 0) {
                handler = mediaSourceAttributes.handler;
            }
            if ((n & 8) != 0) {
                string = mediaSourceAttributes.userAgent;
            }
            if ((n & 0x10) != 0) {
                transferListener = mediaSourceAttributes.transferListener;
            }
            if ((n & 0x20) != 0) {
                drmSessionManagerProvider = mediaSourceAttributes.drmSessionManagerProvider;
            }
            if ((n & 0x40) != 0) {
                dataSourceFactoryProvider = mediaSourceAttributes.dataSourceFactoryProvider;
            }
            return mediaSourceAttributes.copy(context, uri, handler, string, transferListener, drmSessionManagerProvider, dataSourceFactoryProvider);
        }

        @NotNull
        public String toString() {
            return "MediaSourceAttributes(context=" + this.context + ", uri=" + this.uri + ", handler=" + this.handler + ", userAgent=" + this.userAgent + ", transferListener=" + this.transferListener + ", drmSessionManagerProvider=" + this.drmSessionManagerProvider + ", dataSourceFactoryProvider=" + this.dataSourceFactoryProvider + ')';
        }

        public int hashCode() {
            int result = this.context.hashCode();
            result = result * 31 + this.uri.hashCode();
            result = result * 31 + this.handler.hashCode();
            result = result * 31 + this.userAgent.hashCode();
            result = result * 31 + (this.transferListener == null ? 0 : this.transferListener.hashCode());
            result = result * 31 + this.drmSessionManagerProvider.hashCode();
            result = result * 31 + this.dataSourceFactoryProvider.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MediaSourceAttributes)) {
                return false;
            }
            MediaSourceAttributes mediaSourceAttributes = (MediaSourceAttributes)other;
            if (!Intrinsics.areEqual((Object)this.context, (Object)mediaSourceAttributes.context)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.uri, (Object)mediaSourceAttributes.uri)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.handler, (Object)mediaSourceAttributes.handler)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.userAgent, (Object)mediaSourceAttributes.userAgent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.transferListener, (Object)mediaSourceAttributes.transferListener)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.drmSessionManagerProvider, (Object)mediaSourceAttributes.drmSessionManagerProvider)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.dataSourceFactoryProvider, (Object)mediaSourceAttributes.dataSourceFactoryProvider);
        }
    }
}

