/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.renderer.provider;

import android.content.Context;
import android.os.Handler;
import androidx.annotation.OptIn;
import androidx.media3.common.audio.AudioProcessor;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.Renderer;
import androidx.media3.exoplayer.audio.AudioCapabilities;
import androidx.media3.exoplayer.audio.AudioRendererEventListener;
import androidx.media3.exoplayer.audio.MediaCodecAudioRenderer;
import androidx.media3.exoplayer.mediacodec.MediaCodecSelector;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.core.renderer.provider.RenderProvider;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/devbrackets/android/exomedia/core/renderer/provider/AudioRenderProvider;", "Lcom/devbrackets/android/exomedia/core/renderer/provider/RenderProvider;", "()V", "latestRenderers", "", "Landroidx/media3/exoplayer/Renderer;", "buildRenderer", "className", "", "handler", "Landroid/os/Handler;", "listener", "Landroidx/media3/exoplayer/audio/AudioRendererEventListener;", "buildRenderers", "context", "Landroid/content/Context;", "getLatestRenderers", "rendererClasses", "type", "Lcom/devbrackets/android/exomedia/core/renderer/RendererType;", "library_release"})
@OptIn(markerClass={UnstableApi.class})
@SourceDebugExtension(value={"SMAP\nAudioRenderProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioRenderProvider.kt\ncom/devbrackets/android/exomedia/core/renderer/provider/AudioRenderProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1855#2,2:68\n*S KotlinDebug\n*F\n+ 1 AudioRenderProvider.kt\ncom/devbrackets/android/exomedia/core/renderer/provider/AudioRenderProvider\n*L\n39#1:68,2\n*E\n"})
public class AudioRenderProvider
implements RenderProvider {
    @NotNull
    private List<? extends Renderer> latestRenderers = CollectionsKt.emptyList();

    @Override
    @NotNull
    public RendererType type() {
        return RendererType.AUDIO;
    }

    @Override
    @NotNull
    public List<String> rendererClasses() {
        Object[] objectArray = new String[]{"androidx.media3.exoplayer.ext.opus.LibopusAudioRenderer", "androidx.media3.exoplayer.ext.flac.LibflacAudioRenderer", "androidx.media3.exoplayer.ext.ffmpeg.FfmpegAudioRenderer"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<Renderer> getLatestRenderers() {
        return this.latestRenderers;
    }

    @NotNull
    public final List<Renderer> buildRenderers(@NotNull Context context, @NotNull Handler handler, @NotNull AudioRendererEventListener listener2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        List renderers = new ArrayList();
        AudioCapabilities audioCapabilities = AudioCapabilities.getCapabilities((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)audioCapabilities, (String)"getCapabilities(context)");
        AudioCapabilities audioCapabilities2 = audioCapabilities;
        renderers.add(new MediaCodecAudioRenderer(context, MediaCodecSelector.DEFAULT, handler, listener2, audioCapabilities2, new AudioProcessor[0]));
        Iterable $this$forEach$iv = this.rendererClasses();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String className = (String)element$iv;
            boolean bl = false;
            try {
                Renderer renderer = this.buildRenderer(className, handler, listener2);
                renderers.add(renderer);
            }
            catch (Exception exception) {
            }
        }
        List it = list = renderers;
        boolean bl = false;
        this.latestRenderers = it;
        return list;
    }

    private final Renderer buildRenderer(String className, Handler handler, AudioRendererEventListener listener2) {
        Class<?> rendererClass = Class.forName(className);
        Class[] classArray = new Class[]{Long.TYPE, AudioRendererEventListener.class};
        Constructor<?> constructor = rendererClass.getConstructor(classArray);
        Object[] objectArray = new Object[]{handler, listener2};
        Object obj = constructor.newInstance(objectArray);
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type androidx.media3.exoplayer.Renderer");
        return (Renderer)obj;
    }
}

