/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.audio;

import android.net.Uri;
import androidx.annotation.IntRange;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.Timeline;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.TrackGroupArray;
import com.devbrackets.android.exomedia.core.ListenerMux;
import com.devbrackets.android.exomedia.core.audio.AudioPlayerApi;
import com.devbrackets.android.exomedia.core.audio.MediaItem;
import com.devbrackets.android.exomedia.core.listener.MetadataListener;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.devbrackets.android.exomedia.nmp.ExoMediaPlayerImpl;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfig;
import com.devbrackets.android.exomedia.nmp.manager.window.WindowInfo;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001:\u0001qB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\u000bH\u0016J\u0018\u0010N\u001a\u00020\u00062\u0006\u0010M\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020\u0006H\u0016J\u0010\u0010P\u001a\u00020+2\u0006\u0010M\u001a\u00020\u000bH\u0016J\b\u0010Q\u001a\u00020LH\u0016J\b\u0010R\u001a\u00020LH\u0016J\b\u0010S\u001a\u00020LH\u0016J\b\u0010T\u001a\u00020+H\u0016J\u0012\u0010U\u001a\u00020L2\b\b\u0001\u0010V\u001a\u00020\u0018H\u0016J\u0010\u0010W\u001a\u00020L2\u0006\u0010X\u001a\u00020YH\u0016J\u0010\u0010Z\u001a\u00020L2\u0006\u0010[\u001a\u00020.H\u0016J\u0012\u0010\\\u001a\u00020L2\b\u0010]\u001a\u0004\u0018\u00010^H\u0016J\u0010\u0010_\u001a\u00020+2\u0006\u0010`\u001a\u000208H\u0016J\u0010\u0010a\u001a\u00020+2\u0006\u0010b\u001a\u000208H\u0016J\u0018\u0010c\u001a\u00020L2\u0006\u0010M\u001a\u00020\u000b2\u0006\u0010d\u001a\u00020+H\u0016J\u0010\u0010e\u001a\u00020L2\u0006\u0010f\u001a\u00020\u0006H\u0016J \u0010g\u001a\u00020L2\u0006\u0010M\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020\u00062\u0006\u0010h\u001a\u00020\u0006H\u0016J\u0010\u0010i\u001a\u00020L2\u0006\u0010j\u001a\u00020kH\u0016J\u0010\u0010l\u001a\u00020L2\u0006\u0010m\u001a\u00020\u0006H\u0016J\b\u0010n\u001a\u00020LH\u0016J\b\u0010o\u001a\u00020LH\u0016J\b\u0010p\u001a\u00020+H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR(\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001aR\u001e\u0010$\u001a\u00060%R\u00020\u0000X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010,R\u001c\u0010-\u001a\u0004\u0018\u00010.X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u00020+X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010,\"\u0004\b5\u00106R\u0014\u00107\u001a\u0002088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0014\u0010;\u001a\u0002088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010:R\u0014\u0010=\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u0012R\u0014\u0010?\u001a\u00020@8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR$\u0010C\u001a\u0002082\u0006\u0010\u001b\u001a\u0002088V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bD\u0010:\"\u0004\bE\u0010FR\u0016\u0010G\u001a\u0004\u0018\u00010H8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010J\u00a8\u0006r"}, d2={"Lcom/devbrackets/android/exomedia/core/audio/ExoAudioPlayer;", "Lcom/devbrackets/android/exomedia/core/audio/AudioPlayerApi;", "config", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "(Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;)V", "audioSessionId", "", "getAudioSessionId", "()I", "availableTracks", "", "Lcom/devbrackets/android/exomedia/core/renderer/RendererType;", "Landroidx/media3/exoplayer/source/TrackGroupArray;", "getAvailableTracks", "()Ljava/util/Map;", "bufferedPercent", "getBufferedPercent", "getConfig", "()Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "corePlayer", "Lcom/devbrackets/android/exomedia/nmp/ExoMediaPlayerImpl;", "getCorePlayer", "()Lcom/devbrackets/android/exomedia/nmp/ExoMediaPlayerImpl;", "currentPosition", "", "getCurrentPosition", "()J", "value", "Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "drmSessionManagerProvider", "getDrmSessionManagerProvider", "()Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "setDrmSessionManagerProvider", "(Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;)V", "duration", "getDuration", "internalListeners", "Lcom/devbrackets/android/exomedia/core/audio/ExoAudioPlayer$InternalListeners;", "getInternalListeners", "()Lcom/devbrackets/android/exomedia/core/audio/ExoAudioPlayer$InternalListeners;", "setInternalListeners", "(Lcom/devbrackets/android/exomedia/core/audio/ExoAudioPlayer$InternalListeners;)V", "isPlaying", "", "()Z", "mux", "Lcom/devbrackets/android/exomedia/core/ListenerMux;", "getMux", "()Lcom/devbrackets/android/exomedia/core/ListenerMux;", "setMux", "(Lcom/devbrackets/android/exomedia/core/ListenerMux;)V", "playRequested", "getPlayRequested", "setPlayRequested", "(Z)V", "playbackPitch", "", "getPlaybackPitch", "()F", "playbackSpeed", "getPlaybackSpeed", "playerConfig", "getPlayerConfig", "timeline", "Landroidx/media3/common/Timeline;", "getTimeline", "()Landroidx/media3/common/Timeline;", "volume", "getVolume", "setVolume", "(F)V", "windowInfo", "Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "getWindowInfo", "()Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "clearSelectedTracks", "", "type", "getSelectedTrackIndex", "groupIndex", "isRendererEnabled", "pause", "release", "reset", "restart", "seekTo", "milliseconds", "setAudioAttributes", "attributes", "Landroidx/media3/common/AudioAttributes;", "setListenerMux", "listenerMux", "setMedia", "mediaItem", "Lcom/devbrackets/android/exomedia/core/audio/MediaItem;", "setPlaybackPitch", "pitch", "setPlaybackSpeed", "speed", "setRendererEnabled", "enabled", "setRepeatMode", "repeatMode", "setSelectedTrack", "trackIndex", "setTrackSelectionParameters", "parameters", "Landroidx/media3/common/TrackSelectionParameters;", "setWakeLevel", "levelAndFlags", "start", "stop", "trackSelectionAvailable", "InternalListeners", "library_release"})
public class ExoAudioPlayer
implements AudioPlayerApi {
    @NotNull
    private final PlayerConfig config;
    @NotNull
    private final ExoMediaPlayerImpl corePlayer;
    @Nullable
    private ListenerMux mux;
    @NotNull
    private InternalListeners internalListeners;
    private boolean playRequested;

    public ExoAudioPlayer(@NotNull PlayerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.corePlayer = new ExoMediaPlayerImpl(this.config);
        this.internalListeners = new InternalListeners();
        this.corePlayer.setMetadataListener(this.internalListeners);
        this.corePlayer.setBufferUpdateListener(this.internalListeners);
    }

    @NotNull
    protected final PlayerConfig getConfig() {
        return this.config;
    }

    @NotNull
    protected final ExoMediaPlayerImpl getCorePlayer() {
        return this.corePlayer;
    }

    @Nullable
    protected final ListenerMux getMux() {
        return this.mux;
    }

    protected final void setMux(@Nullable ListenerMux listenerMux2) {
        this.mux = listenerMux2;
    }

    @NotNull
    protected final InternalListeners getInternalListeners() {
        return this.internalListeners;
    }

    protected final void setInternalListeners(@NotNull InternalListeners internalListeners) {
        Intrinsics.checkNotNullParameter((Object)internalListeners, (String)"<set-?>");
        this.internalListeners = internalListeners;
    }

    protected final boolean getPlayRequested() {
        return this.playRequested;
    }

    protected final void setPlayRequested(boolean bl) {
        this.playRequested = bl;
    }

    @Override
    public float getVolume() {
        return this.corePlayer.getVolume();
    }

    @Override
    public void setVolume(float value) {
        this.corePlayer.setVolume(value);
    }

    @Override
    @NotNull
    public PlayerConfig getPlayerConfig() {
        return this.config;
    }

    @Override
    public boolean isPlaying() {
        return this.corePlayer.getPlayWhenReady();
    }

    @Override
    public long getDuration() {
        ListenerMux listenerMux2 = this.mux;
        Intrinsics.checkNotNull((Object)listenerMux2);
        return !listenerMux2.isPrepared() ? 0L : this.corePlayer.getDuration();
    }

    @Override
    public long getCurrentPosition() {
        ListenerMux listenerMux2 = this.mux;
        Intrinsics.checkNotNull((Object)listenerMux2);
        return !listenerMux2.isPrepared() ? 0L : this.corePlayer.getCurrentPosition();
    }

    @Override
    public int getBufferedPercent() {
        return this.corePlayer.getBufferedPercent();
    }

    @Override
    @Nullable
    public WindowInfo getWindowInfo() {
        return this.corePlayer.getWindowInfo();
    }

    @Override
    @NotNull
    public Timeline getTimeline() {
        return this.corePlayer.getTimeline();
    }

    @Override
    public int getAudioSessionId() {
        return this.corePlayer.getAudioSessionId();
    }

    @Override
    public float getPlaybackSpeed() {
        return this.corePlayer.getPlaybackSpeed();
    }

    @Override
    public float getPlaybackPitch() {
        return this.corePlayer.getPlaybackPitch();
    }

    @Override
    @Nullable
    public Map<RendererType, TrackGroupArray> getAvailableTracks() {
        return this.corePlayer.getAvailableTracks();
    }

    @Override
    @Nullable
    public DrmSessionManagerProvider getDrmSessionManagerProvider() {
        return this.corePlayer.getDrmSessionManagerProvider();
    }

    @Override
    public void setDrmSessionManagerProvider(@Nullable DrmSessionManagerProvider value) {
        this.corePlayer.setDrmSessionManagerProvider(value);
    }

    @Override
    public void setMedia(@Nullable MediaItem mediaItem) {
        ListenerMux listenerMux2 = this.mux;
        if (listenerMux2 != null) {
            listenerMux2.setNotifiedPrepared(false);
        }
        this.corePlayer.seekTo(0L);
        MediaItem mediaItem2 = mediaItem;
        if (mediaItem2 != null && (mediaItem2 = mediaItem2.getMediaSource()) != null) {
            MediaItem it = mediaItem2;
            boolean bl = false;
            this.corePlayer.setMediaSource((MediaSource)it);
            ListenerMux listenerMux3 = this.mux;
            if (listenerMux3 != null) {
                listenerMux3.setNotifiedCompleted(false);
            }
            this.corePlayer.prepare();
            return;
        }
        MediaItem mediaItem3 = mediaItem;
        if (mediaItem3 != null && (mediaItem3 = mediaItem3.getUri()) != null) {
            MediaItem it = mediaItem3;
            boolean bl = false;
            this.corePlayer.setMediaUri((Uri)it);
            ListenerMux listenerMux4 = this.mux;
            if (listenerMux4 != null) {
                listenerMux4.setNotifiedCompleted(false);
            }
            this.corePlayer.prepare();
            return;
        }
        this.corePlayer.setMediaSource(null);
    }

    @Override
    public void reset() {
    }

    @Override
    public void seekTo(@IntRange(from=0L) long milliseconds) {
        this.corePlayer.seekTo(milliseconds);
    }

    @Override
    public void start() {
        this.corePlayer.setPlayWhenReady(true);
        ListenerMux listenerMux2 = this.mux;
        if (listenerMux2 != null) {
            listenerMux2.setNotifiedCompleted(false);
        }
        this.playRequested = true;
    }

    @Override
    public void pause() {
        this.corePlayer.setPlayWhenReady(false);
        this.playRequested = false;
    }

    @Override
    public void stop() {
        this.corePlayer.stop();
        this.playRequested = false;
    }

    @Override
    public boolean restart() {
        block2: {
            if (!this.corePlayer.restart()) {
                return false;
            }
            ListenerMux listenerMux2 = this.mux;
            if (listenerMux2 != null) {
                listenerMux2.setNotifiedCompleted(false);
            }
            ListenerMux listenerMux3 = this.mux;
            if (listenerMux3 == null) break block2;
            listenerMux3.setNotifiedPrepared(false);
        }
        return true;
    }

    @Override
    public void release() {
        this.corePlayer.release();
    }

    @Override
    public boolean setPlaybackSpeed(float speed) {
        this.corePlayer.setPlaybackSpeed(speed);
        return true;
    }

    @Override
    public boolean setPlaybackPitch(float pitch) {
        this.corePlayer.setPlaybackPitch(pitch);
        return true;
    }

    @Override
    public void setAudioAttributes(@NotNull AudioAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.corePlayer.setAudioAttributes(attributes);
    }

    @Override
    public void setWakeLevel(int levelAndFlags) {
        this.corePlayer.setWakeLevel(levelAndFlags);
    }

    @Override
    public boolean trackSelectionAvailable() {
        return true;
    }

    @Override
    public void setTrackSelectionParameters(@NotNull TrackSelectionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.corePlayer.setTrackSelectionParameters(parameters);
    }

    @Override
    public void setSelectedTrack(@NotNull RendererType type, int groupIndex, int trackIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.corePlayer.setSelectedTrack(type, groupIndex, trackIndex);
    }

    @Override
    public int getSelectedTrackIndex(@NotNull RendererType type, int groupIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.corePlayer.getSelectedTrackIndex(type, groupIndex);
    }

    @Override
    public void clearSelectedTracks(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.corePlayer.clearSelectedTracks(type);
    }

    @Override
    public void setRendererEnabled(@NotNull RendererType type, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.corePlayer.setRendererEnabled(type, enabled);
    }

    @Override
    public boolean isRendererEnabled(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.corePlayer.isRendererEnabled(type);
    }

    @Override
    public void setListenerMux(@NotNull ListenerMux listenerMux2) {
        Intrinsics.checkNotNullParameter((Object)listenerMux2, (String)"listenerMux");
        ListenerMux listenerMux3 = this.mux;
        if (listenerMux3 != null) {
            ListenerMux oldListenerMux = listenerMux3;
            boolean bl = false;
            this.corePlayer.removeListener(oldListenerMux);
            this.corePlayer.removeAnalyticsListener(oldListenerMux);
        }
        this.mux = listenerMux2;
        this.corePlayer.addListener(listenerMux2);
        this.corePlayer.addAnalyticsListener(listenerMux2);
    }

    @Override
    public void setRepeatMode(int repeatMode) {
        this.corePlayer.setRepeatMode(repeatMode);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/devbrackets/android/exomedia/core/audio/ExoAudioPlayer$InternalListeners;", "Lcom/devbrackets/android/exomedia/core/listener/MetadataListener;", "Lcom/devbrackets/android/exomedia/listener/OnBufferUpdateListener;", "(Lcom/devbrackets/android/exomedia/core/audio/ExoAudioPlayer;)V", "onBufferingUpdate", "", "percent", "", "onMetadata", "metadata", "Landroidx/media3/common/Metadata;", "library_release"})
    protected final class InternalListeners
    implements MetadataListener,
    OnBufferUpdateListener {
        @Override
        public void onMetadata(@NotNull androidx.media3.common.Metadata metadata) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                ListenerMux listenerMux2 = ExoAudioPlayer.this.getMux();
                if (listenerMux2 == null) break block0;
                listenerMux2.onMetadata(metadata);
            }
        }

        @Override
        public void onBufferingUpdate(@IntRange(from=0L, to=100L) int percent) {
            block0: {
                ListenerMux listenerMux2 = ExoAudioPlayer.this.getMux();
                if (listenerMux2 == null) break block0;
                listenerMux2.onBufferingUpdate(percent);
            }
        }
    }
}

