/*
 * Decompiled with CFR 0.152.
 */
package com.hieupt.android.standalonescrollbar.viewhelper;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hieupt.android.standalonescrollbar.ScrollableView;
import com.hieupt.android.standalonescrollbar.VerticalScrollableView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J+\u0010\u001f\u001a\u00020 2!\u0010!\u001a\u001d\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020 0\"H\u0016J+\u0010'\u001a\u00020 2!\u0010(\u001a\u001d\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020 0\"H\u0016J\u0010\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\u0006H\u0016J\u0018\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0006H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0014\u0010\u000f\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0014\u0010\u0011\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u0014\u0010\u0013\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\bR\u0014\u0010\u001d\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\b\u00a8\u0006-"}, d2={"Lcom/hieupt/android/standalonescrollbar/viewhelper/VerticalRecyclerViewHelper;", "Lcom/hieupt/android/standalonescrollbar/VerticalScrollableView;", "view", "Landroidx/recyclerview/widget/RecyclerView;", "(Landroidx/recyclerview/widget/RecyclerView;)V", "firstItemAdapterPosition", "", "getFirstItemAdapterPosition", "()I", "firstItemOffset", "getFirstItemOffset", "firstItemPosition", "getFirstItemPosition", "itemCount", "getItemCount", "itemHeight", "getItemHeight", "scrollOffset", "getScrollOffset", "scrollRange", "getScrollRange", "tempRect", "Landroid/graphics/Rect;", "verticalLinearLayoutManager", "Landroidx/recyclerview/widget/LinearLayoutManager;", "getVerticalLinearLayoutManager", "()Landroidx/recyclerview/widget/LinearLayoutManager;", "viewHeight", "getViewHeight", "viewWidth", "getViewWidth", "addOnDraw", "", "onDraw", "Lkotlin/Function1;", "Lcom/hieupt/android/standalonescrollbar/ScrollableView;", "Lkotlin/ParameterName;", "name", "caller", "addOnScrollChangedListener", "onScrollChanged", "scrollTo", "offset", "scrollToPositionWithOffset", "position", "android-standalone-scroll-bar_release"})
public final class VerticalRecyclerViewHelper
implements VerticalScrollableView {
    private final Rect tempRect;
    private final RecyclerView view;

    @Override
    public void addOnScrollChangedListener(@NotNull Function1<? super ScrollableView, Unit> onScrollChanged) {
        Intrinsics.checkNotNullParameter(onScrollChanged, (String)"onScrollChanged");
        this.view.addOnScrollListener(new RecyclerView.OnScrollListener(this, onScrollChanged){
            final /* synthetic */ VerticalRecyclerViewHelper this$0;
            final /* synthetic */ Function1 $onScrollChanged;

            public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                this.$onScrollChanged.invoke((Object)this.this$0);
            }
            {
                this.this$0 = this$0;
                this.$onScrollChanged = $captured_local_variable$1;
            }
        });
    }

    @Override
    public void addOnDraw(@NotNull Function1<? super ScrollableView, Unit> onDraw) {
        Intrinsics.checkNotNullParameter(onDraw, (String)"onDraw");
        this.view.addItemDecoration(new RecyclerView.ItemDecoration(this, onDraw){
            final /* synthetic */ VerticalRecyclerViewHelper this$0;
            final /* synthetic */ Function1 $onDraw;

            public void onDrawOver(@NotNull Canvas c, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                super.onDrawOver(c, parent, state);
                this.$onDraw.invoke((Object)this.this$0);
            }
            {
                this.this$0 = this$0;
                this.$onDraw = $captured_local_variable$1;
            }
        });
    }

    @Override
    public int getViewWidth() {
        return this.view.getWidth();
    }

    @Override
    public int getViewHeight() {
        return this.view.getHeight();
    }

    @Override
    public int getScrollRange() {
        return this.getItemCount() == 0 || this.getItemHeight() == 0 ? 0 : this.view.getPaddingTop() + this.getItemCount() * this.getItemHeight() + this.view.getPaddingBottom();
    }

    @Override
    public int getScrollOffset() {
        int firstItemPosition = this.getFirstItemPosition();
        if (firstItemPosition == -1) {
            return 0;
        }
        int itemHeight = this.getItemHeight();
        int firstItemTop = this.getFirstItemOffset();
        return this.view.getPaddingTop() + firstItemPosition * itemHeight - firstItemTop;
    }

    @Override
    public void scrollTo(int offset) {
        this.view.stopScroll();
        int scrollOffset = offset - this.view.getPaddingTop();
        int itemHeight = this.getItemHeight();
        int n = 0;
        int n2 = scrollOffset / itemHeight;
        boolean bl = false;
        int firstItemPosition = Math.max(n, n2);
        int firstItemTop = firstItemPosition * itemHeight - scrollOffset;
        this.scrollToPositionWithOffset(firstItemPosition, firstItemTop);
    }

    private final int getItemCount() {
        LinearLayoutManager linearLayoutManager = this.getVerticalLinearLayoutManager();
        if (linearLayoutManager == null) {
            return 0;
        }
        LinearLayoutManager linearLayoutManager2 = linearLayoutManager;
        int itemCount = linearLayoutManager2.getItemCount();
        if (itemCount == 0) {
            return 0;
        }
        if (linearLayoutManager2 instanceof GridLayoutManager) {
            itemCount = (itemCount - 1) / ((GridLayoutManager)linearLayoutManager2).getSpanCount() + 1;
        }
        return itemCount;
    }

    private final int getItemHeight() {
        if (this.view.getChildCount() == 0) {
            return 0;
        }
        View itemView = this.view.getChildAt(0);
        this.view.getDecoratedBoundsWithMargins(itemView, this.tempRect);
        return this.tempRect.height();
    }

    private final int getFirstItemPosition() {
        int position = this.getFirstItemAdapterPosition();
        LinearLayoutManager linearLayoutManager = this.getVerticalLinearLayoutManager();
        if (linearLayoutManager == null) {
            return -1;
        }
        LinearLayoutManager linearLayoutManager2 = linearLayoutManager;
        if (linearLayoutManager2 instanceof GridLayoutManager) {
            position /= ((GridLayoutManager)linearLayoutManager2).getSpanCount();
        }
        return position;
    }

    private final int getFirstItemAdapterPosition() {
        if (this.view.getChildCount() == 0) {
            return -1;
        }
        View itemView = this.view.getChildAt(0);
        LinearLayoutManager linearLayoutManager = this.getVerticalLinearLayoutManager();
        if (linearLayoutManager == null) {
            return -1;
        }
        LinearLayoutManager linearLayoutManager2 = linearLayoutManager;
        return linearLayoutManager2.getPosition(itemView);
    }

    private final int getFirstItemOffset() {
        if (this.view.getChildCount() == 0) {
            return -1;
        }
        View itemView = this.view.getChildAt(0);
        this.view.getDecoratedBoundsWithMargins(itemView, this.tempRect);
        return this.tempRect.top;
    }

    private final void scrollToPositionWithOffset(int position, int offset) {
        int scrollPosition = position;
        LinearLayoutManager linearLayoutManager = this.getVerticalLinearLayoutManager();
        if (linearLayoutManager == null) {
            return;
        }
        LinearLayoutManager linearLayoutManager2 = linearLayoutManager;
        if (linearLayoutManager2 instanceof GridLayoutManager) {
            scrollPosition *= ((GridLayoutManager)linearLayoutManager2).getSpanCount();
        }
        int scrollOffset = offset - this.view.getPaddingTop();
        linearLayoutManager2.scrollToPositionWithOffset(scrollPosition, scrollOffset);
    }

    private final LinearLayoutManager getVerticalLinearLayoutManager() {
        RecyclerView.LayoutManager layoutManager = this.view.getLayoutManager();
        if (!(layoutManager instanceof LinearLayoutManager)) {
            layoutManager = null;
        }
        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
        if (linearLayoutManager == null) {
            return null;
        }
        LinearLayoutManager layoutManager2 = linearLayoutManager;
        return layoutManager2.getOrientation() != 1 ? null : layoutManager2;
    }

    public VerticalRecyclerViewHelper(@NotNull RecyclerView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
        this.tempRect = new Rect();
    }

    @Override
    public int getScrollOffsetRange() {
        return VerticalScrollableView.DefaultImpls.getScrollOffsetRange(this);
    }
}

