/*
 * Decompiled with CFR 0.152.
 */
package com.hieupt.android.standalonescrollbar.viewhelper;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hieupt.android.standalonescrollbar.HorizontalScrollableView;
import com.hieupt.android.standalonescrollbar.ScrollableView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J+\u0010\"\u001a\u00020#2!\u0010$\u001a\u001d\u0012\u0013\u0012\u00110&\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b()\u0012\u0004\u0012\u00020#0%H\u0016J+\u0010*\u001a\u00020#2!\u0010+\u001a\u001d\u0012\u0013\u0012\u00110&\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b()\u0012\u0004\u0012\u00020#0%H\u0016J\u0010\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020\u0006H\u0016J\u0018\u0010.\u001a\u00020#2\u0006\u0010/\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u0006H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\bR\u0014\u0010\u0016\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\bR\u0014\u0010\u0018\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\bR\u0014\u0010\u001a\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\bR\u0014\u0010 \u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\b\u00a8\u00060"}, d2={"Lcom/hieupt/android/standalonescrollbar/viewhelper/HorizontalRecyclerViewHelper;", "Lcom/hieupt/android/standalonescrollbar/HorizontalScrollableView;", "view", "Landroidx/recyclerview/widget/RecyclerView;", "(Landroidx/recyclerview/widget/RecyclerView;)V", "firstItemAdapterPosition", "", "getFirstItemAdapterPosition", "()I", "firstItemOffset", "getFirstItemOffset", "firstItemPosition", "getFirstItemPosition", "horizontalLinearLayoutManager", "Landroidx/recyclerview/widget/LinearLayoutManager;", "getHorizontalLinearLayoutManager", "()Landroidx/recyclerview/widget/LinearLayoutManager;", "isLayoutRtl", "", "()Z", "itemCount", "getItemCount", "itemWidth", "getItemWidth", "scrollOffset", "getScrollOffset", "scrollRange", "getScrollRange", "tempRect", "Landroid/graphics/Rect;", "viewHeight", "getViewHeight", "viewWidth", "getViewWidth", "addOnDraw", "", "onDraw", "Lkotlin/Function1;", "Lcom/hieupt/android/standalonescrollbar/ScrollableView;", "Lkotlin/ParameterName;", "name", "caller", "addOnScrollChangedListener", "onScrollChanged", "scrollTo", "offset", "scrollToPositionWithOffset", "position", "android-standalone-scroll-bar_release"})
public final class HorizontalRecyclerViewHelper
implements HorizontalScrollableView {
    private final Rect tempRect;
    private final RecyclerView view;

    private final boolean isLayoutRtl() {
        return this.view.getLayoutDirection() == 1;
    }

    @Override
    public void addOnScrollChangedListener(@NotNull Function1<? super ScrollableView, Unit> onScrollChanged) {
        Intrinsics.checkNotNullParameter(onScrollChanged, (String)"onScrollChanged");
        this.view.addOnScrollListener(new RecyclerView.OnScrollListener(this, onScrollChanged){
            final /* synthetic */ HorizontalRecyclerViewHelper this$0;
            final /* synthetic */ Function1 $onScrollChanged;

            public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                this.$onScrollChanged.invoke((Object)this.this$0);
            }
            {
                this.this$0 = this$0;
                this.$onScrollChanged = $captured_local_variable$1;
            }
        });
    }

    @Override
    public void addOnDraw(@NotNull Function1<? super ScrollableView, Unit> onDraw) {
        Intrinsics.checkNotNullParameter(onDraw, (String)"onDraw");
        this.view.addItemDecoration(new RecyclerView.ItemDecoration(this, onDraw){
            final /* synthetic */ HorizontalRecyclerViewHelper this$0;
            final /* synthetic */ Function1 $onDraw;

            public void onDrawOver(@NotNull Canvas c, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                super.onDrawOver(c, parent, state);
                this.$onDraw.invoke((Object)this.this$0);
            }
            {
                this.this$0 = this$0;
                this.$onDraw = $captured_local_variable$1;
            }
        });
    }

    @Override
    public int getViewWidth() {
        return this.view.getWidth();
    }

    @Override
    public int getViewHeight() {
        return this.view.getHeight();
    }

    @Override
    public int getScrollRange() {
        return this.getItemCount() == 0 || this.getItemWidth() == 0 ? 0 : this.view.getPaddingStart() + this.getItemCount() * this.getItemWidth() + this.view.getPaddingEnd();
    }

    @Override
    public int getScrollOffset() {
        int firstItemPosition = this.getFirstItemPosition();
        if (firstItemPosition == -1) {
            return 0;
        }
        int itemWidth = this.getItemWidth();
        int firstItemStart = this.getFirstItemOffset();
        return this.isLayoutRtl() ? this.view.getPaddingStart() + firstItemPosition * itemWidth + firstItemStart - this.view.getWidth() : this.view.getPaddingStart() + firstItemPosition * itemWidth - firstItemStart;
    }

    @Override
    public void scrollTo(int offset) {
        this.view.stopScroll();
        int scrollOffset = offset - this.view.getPaddingStart();
        int itemWidth = this.getItemWidth();
        int n = 0;
        int n2 = scrollOffset / itemWidth;
        boolean bl = false;
        int firstItemPosition = Math.max(n, n2);
        int firstItemStart = firstItemPosition * itemWidth - scrollOffset;
        this.scrollToPositionWithOffset(firstItemPosition, firstItemStart);
    }

    private final int getItemCount() {
        LinearLayoutManager linearLayoutManager = this.getHorizontalLinearLayoutManager();
        if (linearLayoutManager == null) {
            return 0;
        }
        LinearLayoutManager linearLayoutManager2 = linearLayoutManager;
        int itemCount = linearLayoutManager2.getItemCount();
        if (itemCount == 0) {
            return 0;
        }
        if (linearLayoutManager2 instanceof GridLayoutManager) {
            itemCount = (itemCount - 1) / ((GridLayoutManager)linearLayoutManager2).getSpanCount() + 1;
        }
        return itemCount;
    }

    private final int getItemWidth() {
        if (this.view.getChildCount() == 0) {
            return 0;
        }
        View itemView = this.view.getChildAt(0);
        this.view.getDecoratedBoundsWithMargins(itemView, this.tempRect);
        return this.tempRect.width();
    }

    private final int getFirstItemPosition() {
        int position = this.getFirstItemAdapterPosition();
        LinearLayoutManager linearLayoutManager = this.getHorizontalLinearLayoutManager();
        if (linearLayoutManager == null) {
            return -1;
        }
        LinearLayoutManager linearLayoutManager2 = linearLayoutManager;
        if (linearLayoutManager2 instanceof GridLayoutManager) {
            position /= ((GridLayoutManager)linearLayoutManager2).getSpanCount();
        }
        return position;
    }

    private final int getFirstItemAdapterPosition() {
        if (this.view.getChildCount() == 0) {
            return -1;
        }
        View itemView = this.view.getChildAt(0);
        LinearLayoutManager linearLayoutManager = this.getHorizontalLinearLayoutManager();
        if (linearLayoutManager == null) {
            return -1;
        }
        LinearLayoutManager linearLayoutManager2 = linearLayoutManager;
        return linearLayoutManager2.getPosition(itemView);
    }

    private final int getFirstItemOffset() {
        if (this.view.getChildCount() == 0) {
            return -1;
        }
        View itemView = this.view.getChildAt(0);
        this.view.getDecoratedBoundsWithMargins(itemView, this.tempRect);
        return this.isLayoutRtl() ? this.tempRect.right : this.tempRect.left;
    }

    private final void scrollToPositionWithOffset(int position, int offset) {
        int scrollPosition = position;
        LinearLayoutManager linearLayoutManager = this.getHorizontalLinearLayoutManager();
        if (linearLayoutManager == null) {
            return;
        }
        LinearLayoutManager linearLayoutManager2 = linearLayoutManager;
        if (linearLayoutManager2 instanceof GridLayoutManager) {
            scrollPosition *= ((GridLayoutManager)linearLayoutManager2).getSpanCount();
        }
        int scrollOffset = offset - this.view.getPaddingStart();
        linearLayoutManager2.scrollToPositionWithOffset(scrollPosition, scrollOffset);
    }

    private final LinearLayoutManager getHorizontalLinearLayoutManager() {
        RecyclerView.LayoutManager layoutManager = this.view.getLayoutManager();
        if (!(layoutManager instanceof LinearLayoutManager)) {
            layoutManager = null;
        }
        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
        if (linearLayoutManager == null) {
            return null;
        }
        LinearLayoutManager layoutManager2 = linearLayoutManager;
        return layoutManager2.getOrientation() != 0 ? null : layoutManager2;
    }

    public HorizontalRecyclerViewHelper(@NotNull RecyclerView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
        this.tempRect = new Rect();
    }

    @Override
    public int getScrollOffsetRange() {
        return HorizontalScrollableView.DefaultImpls.getScrollOffsetRange(this);
    }
}

