/*
 * Decompiled with CFR 0.152.
 */
package com.datatheorem.android.trustkit.config;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.datatheorem.android.trustkit.config.ConfigurationException;
import com.datatheorem.android.trustkit.config.DomainPinningPolicy;
import com.datatheorem.android.trustkit.config.DomainValidator;
import com.datatheorem.android.trustkit.config.TrustKitConfigurationParser;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.HashSet;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TrustKitConfiguration {
    @NonNull
    private final Set<DomainPinningPolicy> domainPolicies;
    private final boolean shouldOverridePins;
    @Nullable
    private final Set<Certificate> debugCaCertificates;

    public static TrustKitConfiguration fromXmlPolicy(@NonNull Context context, @NonNull XmlPullParser parser) throws CertificateException, XmlPullParserException, IOException {
        return TrustKitConfigurationParser.fromXmlPolicy(context, parser);
    }

    protected TrustKitConfiguration(@NonNull Set<DomainPinningPolicy> domainConfigSet) {
        this(domainConfigSet, false, null);
    }

    protected TrustKitConfiguration(@NonNull Set<DomainPinningPolicy> domainConfigSet, boolean shouldOverridePins, @Nullable Set<Certificate> debugCaCerts) {
        HashSet<String> hostnameSet = new HashSet<String>();
        for (DomainPinningPolicy domainConfig : domainConfigSet) {
            if (hostnameSet.contains(domainConfig.getHostname())) {
                throw new ConfigurationException("Policy contains the same domain defined twice: " + domainConfig.getHostname());
            }
            hostnameSet.add(domainConfig.getHostname());
        }
        this.domainPolicies = domainConfigSet;
        this.shouldOverridePins = shouldOverridePins;
        this.debugCaCertificates = debugCaCerts;
    }

    public boolean shouldOverridePins() {
        return this.shouldOverridePins;
    }

    @Nullable
    public Set<Certificate> getDebugCaCertificates() {
        return this.debugCaCertificates;
    }

    public Set<DomainPinningPolicy> getAllPolicies() {
        return this.domainPolicies;
    }

    @Nullable
    public DomainPinningPolicy getPolicyForHostname(@NonNull String serverHostname) {
        DomainValidator domainValidator = DomainValidator.getInstance(true);
        if (!domainValidator.isValid(serverHostname)) {
            throw new IllegalArgumentException("Invalid domain supplied: " + serverHostname);
        }
        DomainPinningPolicy bestMatchPolicy = null;
        for (DomainPinningPolicy domainPolicy : this.domainPolicies) {
            if (domainPolicy.getHostname().equals(serverHostname)) {
                bestMatchPolicy = domainPolicy;
                break;
            }
            if (!domainPolicy.shouldIncludeSubdomains() || !TrustKitConfiguration.isSubdomain(domainPolicy.getHostname(), serverHostname)) continue;
            if (bestMatchPolicy == null) {
                bestMatchPolicy = domainPolicy;
                continue;
            }
            if (domainPolicy.getHostname().length() <= bestMatchPolicy.getHostname().length()) continue;
            bestMatchPolicy = domainPolicy;
        }
        return bestMatchPolicy;
    }

    private static boolean isSubdomain(@NonNull String domain, @NonNull String subdomain) {
        return subdomain.endsWith(domain) && subdomain.charAt(subdomain.length() - domain.length() - 1) == '.';
    }
}

