/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data.domain.query;

import io.stargate.sdk.data.domain.query.UpdateQueryBuilder;
import io.stargate.sdk.http.domain.FilterKeyword;
import io.stargate.sdk.http.domain.FilterOperator;
import java.util.Map;

public class UpdateQueryFilterBuilder {
    private final String fieldName;
    private final UpdateQueryBuilder builder;

    protected UpdateQueryFilterBuilder(UpdateQueryBuilder builder, String fieldName) {
        this.builder = builder;
        this.fieldName = fieldName;
    }

    private UpdateQueryBuilder simpleOperator(FilterOperator cond, Object value) {
        this.builder.filter.put(this.fieldName, Map.of(cond.getOperator(), value));
        return this.builder;
    }

    private UpdateQueryBuilder simpleKeyword(FilterKeyword key, Object value) {
        this.builder.filter.put(this.fieldName, Map.of(key.getKeyword(), value));
        return this.builder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UpdateQueryBuilder isEqualsTo(Object value) {
        if (FilterKeyword.VECTOR.getKeyword().equals(this.fieldName)) {
            if (!(value instanceof float[])) throw new IllegalArgumentException("Vector must be an array of float");
            this.builder.orderByAnn((float[])value);
            return this.builder;
        } else {
            this.builder.filter.put(this.fieldName, value);
        }
        return this.builder;
    }

    public UpdateQueryBuilder isAnArrayContaining(Object[] value) {
        return this.simpleOperator(FilterOperator.EQUALS_TO, value);
    }

    public UpdateQueryBuilder isAnArrayExactlyEqualsTo(Object[] value) {
        this.builder.filter.put(this.fieldName, Map.of(FilterKeyword.ALL.getKeyword(), value));
        return this.builder;
    }

    public UpdateQueryBuilder hasSubFieldsEqualsTo(Map<String, Object> value) {
        return this.simpleOperator(FilterOperator.EQUALS_TO, value);
    }

    public UpdateQueryBuilder isLessThan(Object value) {
        return this.simpleOperator(FilterOperator.LESS_THAN, value);
    }

    public UpdateQueryBuilder isLessOrEqualsThan(Object value) {
        return this.simpleOperator(FilterOperator.LESS_THAN_OR_EQUALS_TO, value);
    }

    public UpdateQueryBuilder isGreaterThan(Object value) {
        return this.simpleOperator(FilterOperator.GREATER_THAN, value);
    }

    public UpdateQueryBuilder isGreaterOrEqualsThan(Object value) {
        return this.simpleOperator(FilterOperator.GREATER_THAN_OR_EQUALS_TO, value);
    }

    public UpdateQueryBuilder isNotEqualsTo(Object value) {
        return this.simpleOperator(FilterOperator.NOT_EQUALS_TO, value);
    }

    public UpdateQueryBuilder exists() {
        return this.simpleKeyword(FilterKeyword.EXISTS, true);
    }

    public UpdateQueryBuilder hasSize(int size) {
        return this.simpleKeyword(FilterKeyword.SIZE, true);
    }
}

