/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data;

import io.stargate.sdk.ServiceDatacenter;
import io.stargate.sdk.ServiceDeployment;
import io.stargate.sdk.api.TokenProvider;
import io.stargate.sdk.data.NamespaceClient;
import io.stargate.sdk.data.domain.ApiResponse;
import io.stargate.sdk.data.domain.NamespaceDefinition;
import io.stargate.sdk.data.exception.DataApiNamespaceNotFoundException;
import io.stargate.sdk.data.utils.DataApiUtils;
import io.stargate.sdk.http.LoadBalancedHttpClient;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.http.auth.TokenProviderHttpAuth;
import io.stargate.sdk.utils.AnsiUtils;
import io.stargate.sdk.utils.Assert;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataApiClient {
    private static final Logger log = LoggerFactory.getLogger(DataApiClient.class);
    public static final String DEFAULT_ENDPOINT = "http://localhost:8181";
    public static final String PATH_HEALTH_CHECK = "/stargate/health";
    public static final String DEFAULT_SERVICE_ID = "sgv2-json";
    private static final String DEFAULT_DATACENTER = "dc1";
    public static final String PATH_V1 = "/v1";
    public static Function<ServiceHttp, String> rootResource = node -> node.getEndpoint() + PATH_V1;
    protected final LoadBalancedHttpClient stargateHttpClient;

    public DataApiClient() {
        this(DEFAULT_ENDPOINT);
    }

    public DataApiClient(String endpoint) {
        Assert.hasLength((String)endpoint, (String)"stargate endpoint");
        ServiceHttp rest = new ServiceHttp(DEFAULT_SERVICE_ID, endpoint, endpoint + PATH_HEALTH_CHECK);
        TokenProviderHttpAuth tokenProvider = new TokenProviderHttpAuth();
        ServiceDatacenter sDc = new ServiceDatacenter(DEFAULT_DATACENTER, (TokenProvider)tokenProvider, Collections.singletonList(rest));
        ServiceDeployment deploy = new ServiceDeployment().addDatacenter(sDc);
        this.stargateHttpClient = new LoadBalancedHttpClient(deploy);
    }

    public DataApiClient(ServiceDeployment<ServiceHttp> serviceDeployment) {
        Assert.notNull(serviceDeployment, (String)"service deployment topology");
        this.stargateHttpClient = new LoadBalancedHttpClient(serviceDeployment);
    }

    public boolean isNamespaceExists(String namespace) {
        return this.findAllNamespaces().anyMatch(namespace::equals);
    }

    public Stream<String> findAllNamespaces() {
        return this.execute("findNamespaces", null).getStatusKeyAsStringStream("namespaces");
    }

    public NamespaceClient createNamespace(String namespace) {
        this.createNamespace(NamespaceDefinition.builder().name(namespace).build());
        return new NamespaceClient(this.stargateHttpClient, namespace);
    }

    public void createNamespace(NamespaceDefinition req) {
        this.execute("createNamespace", req);
        log.info("Namespace  '" + AnsiUtils.green((String)"{}") + "' has been created", (Object)req.getName());
    }

    public void dropNamespace(String namespace) {
        this.execute("dropNamespace", Map.of("name", namespace));
        log.info("Namespace  '" + AnsiUtils.green((String)"{}") + "' has been deleted", (Object)namespace);
    }

    private ApiResponse execute(String operation, Object payload) {
        return DataApiUtils.executeOperation(this.stargateHttpClient, rootResource, operation, payload);
    }

    public NamespaceClient namespace(String namespace) {
        if (this.findAllNamespaces().noneMatch(namespace::equals)) {
            throw new DataApiNamespaceNotFoundException(namespace);
        }
        return new NamespaceClient(this.stargateHttpClient, namespace);
    }

    public LoadBalancedHttpClient getStargateHttpClient() {
        return this.stargateHttpClient;
    }
}

