/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.request;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import java.util.Map;

public class Startup
extends Message {
    private static final String CQL_VERSION_KEY = "CQL_VERSION";
    private static final String COMPRESSION_KEY = "COMPRESSION";
    private static final String CQL_VERSION = "3.0.0";
    public final Map<String, String> options;

    public Startup(String compressionAlgorithm) {
        super(false, 1);
        this.options = compressionAlgorithm == null || compressionAlgorithm.isEmpty() ? NullAllowingImmutableMap.of(CQL_VERSION_KEY, CQL_VERSION) : NullAllowingImmutableMap.of(CQL_VERSION_KEY, CQL_VERSION, COMPRESSION_KEY, compressionAlgorithm);
    }

    public Startup() {
        this(null);
    }

    public String toString() {
        return "STARTUP " + this.options;
    }

    public static class Codec
    extends Message.Codec {
        public Codec(int protocolVersion) {
            super(1, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder) {
            Startup startup = (Startup)message;
            encoder.writeStringMap(startup.options, dest);
        }

        @Override
        public int encodedSize(Message message) {
            Startup startup = (Startup)message;
            return PrimitiveSizes.sizeOfStringMap(startup.options);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder) {
            Map<String, String> map = decoder.readStringMap(source);
            return new Startup(map.get(Startup.COMPRESSION_KEY));
        }
    }
}

