/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.result;

import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.result.ColumnSpec;
import com.datastax.oss.protocol.internal.response.result.RawType;
import com.datastax.oss.protocol.internal.util.Flags;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RowsMetadata {
    public final List<ColumnSpec> columnSpecs;
    public final int columnCount;
    public final ByteBuffer pagingState;
    public final int[] pkIndices;
    public final byte[] newResultMetadataId;
    public final int flags;

    public RowsMetadata(List<ColumnSpec> columnSpecs, ByteBuffer pagingState, int[] pkIndices, byte[] newResultMetadataId) {
        this(RowsMetadata.computeFlags(false, columnSpecs, pagingState, newResultMetadataId), columnSpecs, columnSpecs.size(), pagingState, pkIndices, newResultMetadataId);
    }

    public RowsMetadata(int columnCount, ByteBuffer pagingState, int[] pkIndices, byte[] newResultMetadataId) {
        this(RowsMetadata.computeFlags(true, Collections.emptyList(), pagingState, newResultMetadataId), Collections.emptyList(), columnCount, pagingState, pkIndices, newResultMetadataId);
    }

    public RowsMetadata(int flags, List<ColumnSpec> columnSpecs, int columnCount, ByteBuffer pagingState, int[] pkIndices, byte[] newResultMetadataId) {
        this.columnSpecs = columnSpecs;
        this.columnCount = columnCount;
        this.pagingState = pagingState;
        this.pkIndices = pkIndices;
        this.newResultMetadataId = newResultMetadataId;
        this.flags = flags;
    }

    protected static int computeFlags(boolean noMetadata, List<ColumnSpec> columnSpecs, ByteBuffer pagingState, byte[] newResultMetadataId) {
        int flags = 0;
        if (noMetadata) {
            flags = Flags.add(flags, 4);
        } else if (RowsMetadata.haveSameTable(columnSpecs)) {
            flags = Flags.add(flags, 1);
        }
        if (pagingState != null) {
            flags = Flags.add(flags, 2);
        }
        if (newResultMetadataId != null) {
            flags = Flags.add(flags, 8);
        }
        return flags;
    }

    public <B> void encode(B dest, PrimitiveCodec<B> encoder, boolean withPkIndices, int protocolVersion) {
        encoder.writeInt(this.flags, dest);
        encoder.writeInt(this.columnCount, dest);
        if (withPkIndices) {
            if (this.pkIndices == null) {
                encoder.writeInt(0, dest);
            } else {
                encoder.writeInt(this.pkIndices.length, dest);
                for (int pkIndex : this.pkIndices) {
                    encoder.writeUnsignedShort(pkIndex, dest);
                }
            }
        }
        if (Flags.contains(this.flags, 2)) {
            encoder.writeBytes(this.pagingState, dest);
        }
        if (Flags.contains(this.flags, 8)) {
            encoder.writeShortBytes(this.newResultMetadataId, dest);
        }
        if (!Flags.contains(this.flags, 4) && !this.columnSpecs.isEmpty()) {
            boolean globalTable = Flags.contains(this.flags, 1);
            if (globalTable) {
                ColumnSpec firstSpec = this.columnSpecs.get(0);
                encoder.writeString(firstSpec.ksName, dest);
                encoder.writeString(firstSpec.tableName, dest);
            }
            for (ColumnSpec spec : this.columnSpecs) {
                if (!globalTable) {
                    encoder.writeString(spec.ksName, dest);
                    encoder.writeString(spec.tableName, dest);
                }
                encoder.writeString(spec.name, dest);
                spec.type.encode(dest, encoder, protocolVersion);
            }
        }
    }

    public int encodedSize(boolean withPkIndices, int protocolVersion) {
        int size = 4;
        size += 4;
        if (Flags.contains(this.flags, 8)) {
            size += PrimitiveSizes.sizeOfShortBytes(this.newResultMetadataId);
        }
        if (withPkIndices) {
            size += 4;
            if (this.pkIndices != null) {
                size += this.pkIndices.length * 2;
            }
        }
        if (Flags.contains(this.flags, 2)) {
            size += PrimitiveSizes.sizeOfBytes(this.pagingState);
        }
        if (!Flags.contains(this.flags, 4) && !this.columnSpecs.isEmpty()) {
            boolean globalTable = Flags.contains(this.flags, 1);
            if (globalTable) {
                ColumnSpec firstSpec = this.columnSpecs.get(0);
                size += PrimitiveSizes.sizeOfString(firstSpec.ksName);
                size += PrimitiveSizes.sizeOfString(firstSpec.tableName);
            }
            for (ColumnSpec spec : this.columnSpecs) {
                if (!globalTable) {
                    size += PrimitiveSizes.sizeOfString(spec.ksName);
                    size += PrimitiveSizes.sizeOfString(spec.tableName);
                }
                size += PrimitiveSizes.sizeOfString(spec.name);
                size += spec.type.encodedSize(protocolVersion);
            }
        }
        return size;
    }

    public static <B> RowsMetadata decode(B source, PrimitiveCodec<B> decoder, boolean withPkIndices, int protocolVersion) {
        List<ColumnSpec> columnSpecs;
        byte[] newResultMetadataId;
        int pkCount;
        int flags = decoder.readInt(source);
        int columnCount = decoder.readInt(source);
        int[] pkIndices = null;
        if (withPkIndices && (pkCount = decoder.readInt(source)) > 0) {
            pkIndices = new int[pkCount];
            for (int i = 0; i < pkCount; ++i) {
                pkIndices[i] = decoder.readUnsignedShort(source);
            }
        }
        ByteBuffer state = Flags.contains(flags, 2) ? decoder.readBytes(source) : null;
        byte[] byArray = newResultMetadataId = Flags.contains(flags, 8) ? decoder.readShortBytes(source) : null;
        if (Flags.contains(flags, 4)) {
            columnSpecs = Collections.emptyList();
        } else {
            boolean globalTablesSpec = Flags.contains(flags, 1);
            String globalKsName = null;
            String globalCfName = null;
            if (globalTablesSpec) {
                globalKsName = decoder.readString(source);
                globalCfName = decoder.readString(source);
            }
            ArrayList<ColumnSpec> tmpSpecs = new ArrayList<ColumnSpec>(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                String ksName = globalTablesSpec ? globalKsName : decoder.readString(source);
                String cfName = globalTablesSpec ? globalCfName : decoder.readString(source);
                String name = decoder.readString(source);
                RawType type = RawType.decode(source, decoder, protocolVersion);
                tmpSpecs.add(new ColumnSpec(ksName, cfName, name, i, type));
            }
            columnSpecs = Collections.unmodifiableList(tmpSpecs);
        }
        return new RowsMetadata(flags, columnSpecs, columnCount, state, pkIndices, newResultMetadataId);
    }

    private static boolean haveSameTable(List<ColumnSpec> specs) {
        if (specs.isEmpty()) {
            return false;
        }
        boolean first = true;
        String ksName = null;
        String tableName = null;
        for (ColumnSpec spec : specs) {
            if (first) {
                first = false;
                ksName = spec.ksName;
                tableName = spec.tableName;
                continue;
            }
            if (Objects.equals(spec.ksName, ksName) && Objects.equals(spec.tableName, tableName)) continue;
            return false;
        }
        return true;
    }
}

