/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.request.query;

import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.ProtocolErrors;
import com.datastax.oss.protocol.internal.request.query.Values;
import com.datastax.oss.protocol.internal.util.Flags;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class QueryOptions {
    public static final QueryOptions DEFAULT = new QueryOptions(1, Collections.emptyList(), Collections.emptyMap(), false, -1, null, 8, Long.MIN_VALUE, null);
    public final int flags;
    public final int consistency;
    public final List<ByteBuffer> positionalValues;
    public final Map<String, ByteBuffer> namedValues;
    public final boolean skipMetadata;
    public final int pageSize;
    public final ByteBuffer pagingState;
    public final int serialConsistency;
    public final long defaultTimestamp;
    public final String keyspace;

    public QueryOptions(int flags, int consistency, List<ByteBuffer> positionalValues, Map<String, ByteBuffer> namedValues, boolean skipMetadata, int pageSize, ByteBuffer pagingState, int serialConsistency, long defaultTimestamp, String keyspace) {
        ProtocolErrors.check(positionalValues.isEmpty() || namedValues.isEmpty(), "Can't have both positional and named values", new Object[0]);
        this.flags = flags;
        this.consistency = consistency;
        this.positionalValues = positionalValues;
        this.namedValues = namedValues;
        this.skipMetadata = skipMetadata;
        this.pageSize = pageSize;
        this.pagingState = pagingState;
        this.serialConsistency = serialConsistency;
        this.defaultTimestamp = defaultTimestamp;
        this.keyspace = keyspace;
    }

    public QueryOptions(int consistency, List<ByteBuffer> positionalValues, Map<String, ByteBuffer> namedValues, boolean skipMetadata, int pageSize, ByteBuffer pagingState, int serialConsistency, long defaultTimestamp, String keyspace) {
        this(QueryOptions.computeFlags(positionalValues, namedValues, skipMetadata, pageSize, pagingState, serialConsistency, defaultTimestamp, keyspace), consistency, positionalValues, namedValues, skipMetadata, pageSize, pagingState, serialConsistency, defaultTimestamp, keyspace);
    }

    protected static int computeFlags(List<ByteBuffer> positionalValues, Map<String, ByteBuffer> namedValues, boolean skipMetadata, int pageSize, ByteBuffer pagingState, int serialConsistency, long defaultTimestamp, String keyspace) {
        int flags = 0;
        if (!positionalValues.isEmpty()) {
            flags = Flags.add(flags, 1);
        }
        if (!namedValues.isEmpty()) {
            flags = Flags.add(flags, 1);
            flags = Flags.add(flags, 64);
        }
        if (skipMetadata) {
            flags = Flags.add(flags, 2);
        }
        if (pageSize > 0) {
            flags = Flags.add(flags, 4);
        }
        if (pagingState != null) {
            flags = Flags.add(flags, 8);
        }
        if (serialConsistency != 8) {
            flags = Flags.add(flags, 16);
        }
        if (defaultTimestamp != Long.MIN_VALUE) {
            flags = Flags.add(flags, 32);
        }
        if (keyspace != null) {
            flags = Flags.add(flags, 128);
        }
        return flags;
    }

    public String toString() {
        return String.format("[cl=%s, positionalVals=%s, namedVals=%s, skip=%b, psize=%d, state=%s, serialCl=%s]", this.consistency, this.positionalValues, this.namedValues, this.skipMetadata, this.pageSize, this.pagingState, this.serialConsistency);
    }

    public static class Codec {
        public final int protocolVersion;

        public Codec(int protocolVersion) {
            this.protocolVersion = protocolVersion;
        }

        public <B> void encode(B dest, QueryOptions options, PrimitiveCodec<B> encoder) {
            encoder.writeUnsignedShort(options.consistency, dest);
            if (this.protocolVersion >= 5) {
                encoder.writeInt(options.flags, dest);
            } else {
                encoder.writeByte((byte)options.flags, dest);
            }
            if (Flags.contains(options.flags, 1)) {
                if (Flags.contains(options.flags, 64)) {
                    Values.writeNamedValues(options.namedValues, dest, encoder);
                } else {
                    Values.writePositionalValues(options.positionalValues, dest, encoder);
                }
            }
            if (Flags.contains(options.flags, 4)) {
                encoder.writeInt(options.pageSize, dest);
            }
            if (Flags.contains(options.flags, 8)) {
                encoder.writeBytes(options.pagingState, dest);
            }
            if (Flags.contains(options.flags, 16)) {
                encoder.writeUnsignedShort(options.serialConsistency, dest);
            }
            if (Flags.contains(options.flags, 32)) {
                encoder.writeLong(options.defaultTimestamp, dest);
            }
            if (Flags.contains(options.flags, 128)) {
                encoder.writeString(options.keyspace, dest);
            }
        }

        public int encodedSize(QueryOptions options) {
            int size = 0;
            size += 2;
            size += this.protocolVersion >= 5 ? 4 : 1;
            if (Flags.contains(options.flags, 1)) {
                size = Flags.contains(options.flags, 64) ? (size += Values.sizeOfNamedValues(options.namedValues)) : (size += Values.sizeOfPositionalValues(options.positionalValues));
            }
            if (Flags.contains(options.flags, 4)) {
                size += 4;
            }
            if (Flags.contains(options.flags, 8)) {
                size += PrimitiveSizes.sizeOfBytes(options.pagingState);
            }
            if (Flags.contains(options.flags, 16)) {
                size += 2;
            }
            if (Flags.contains(options.flags, 32)) {
                size += 8;
            }
            if (Flags.contains(options.flags, 128)) {
                size += PrimitiveSizes.sizeOfString(options.keyspace);
            }
            return size;
        }

        public <B> QueryOptions decode(B source, PrimitiveCodec<B> decoder) {
            int consistency = decoder.readUnsignedShort(source);
            int flags = this.protocolVersion >= 5 ? decoder.readInt(source) : (int)decoder.readByte(source);
            List<ByteBuffer> positionalValues = Collections.emptyList();
            Map<String, ByteBuffer> namedValues = Collections.emptyMap();
            if (Flags.contains(flags, 1)) {
                if (Flags.contains(flags, 64)) {
                    namedValues = Values.readNamedValues(source, decoder);
                } else {
                    positionalValues = Values.readPositionalValues(source, decoder);
                }
            }
            boolean skipMetadata = Flags.contains(flags, 2);
            int pageSize = Flags.contains(flags, 4) ? decoder.readInt(source) : -1;
            ByteBuffer pagingState = Flags.contains(flags, 8) ? decoder.readBytes(source) : null;
            int serialConsistency = Flags.contains(flags, 16) ? decoder.readUnsignedShort(source) : 8;
            long defaultTimestamp = Flags.contains(flags, 32) ? decoder.readLong(source) : Long.MIN_VALUE;
            String keyspace = Flags.contains(flags, 128) ? decoder.readString(source) : null;
            return new QueryOptions(flags, consistency, positionalValues, namedValues, skipMetadata, pageSize, pagingState, serialConsistency, defaultTimestamp, keyspace);
        }
    }
}

