/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public interface PrimitiveCodec<B> {
    public B allocate(int var1);

    public void release(B var1);

    public int sizeOf(B var1);

    public B concat(B var1, B var2);

    public byte readByte(B var1);

    public int readInt(B var1);

    public InetAddress readInetAddr(B var1);

    public long readLong(B var1);

    public int readUnsignedShort(B var1);

    public ByteBuffer readBytes(B var1);

    public byte[] readShortBytes(B var1);

    public String readString(B var1);

    public String readLongString(B var1);

    default public UUID readUuid(B source) {
        long msb = this.readLong(source);
        long lsb = this.readLong(source);
        return new UUID(msb, lsb);
    }

    default public List<String> readStringList(B source) {
        int length = this.readUnsignedShort(source);
        ArrayList<String> l = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            l.add(this.readString(source));
        }
        return Collections.unmodifiableList(l);
    }

    default public Map<String, String> readStringMap(B source) {
        int length = this.readUnsignedShort(source);
        HashMap<String, String> m = new HashMap<String, String>(length);
        for (int i = 0; i < length; ++i) {
            String k = this.readString(source);
            String v = this.readString(source);
            m.put(k, v);
        }
        return Collections.unmodifiableMap(m);
    }

    default public Map<String, List<String>> readStringMultimap(B source) {
        HashMap<String, List<String>> m = new HashMap<String, List<String>>();
        int length = this.readUnsignedShort(source);
        for (int i = 0; i < length; ++i) {
            String key = this.readString(source);
            List<String> value = this.readStringList(source);
            m.put(key, value);
        }
        return Collections.unmodifiableMap(m);
    }

    default public Map<String, ByteBuffer> readBytesMap(B source) {
        int length = this.readUnsignedShort(source);
        HashMap<String, ByteBuffer> m = new HashMap<String, ByteBuffer>(length * 2);
        for (int i = 0; i < length; ++i) {
            String key = this.readString(source);
            ByteBuffer value = this.readBytes(source);
            m.put(key, value);
        }
        return Collections.unmodifiableMap(m);
    }

    default public InetSocketAddress readInet(B source) {
        InetAddress addr = this.readInetAddr(source);
        int port = this.readInt(source);
        return new InetSocketAddress(addr, port);
    }

    public void writeByte(byte var1, B var2);

    public void writeInt(int var1, B var2);

    public void writeInetAddr(InetAddress var1, B var2);

    public void writeLong(long var1, B var3);

    public void writeUnsignedShort(int var1, B var2);

    public void writeString(String var1, B var2);

    public void writeLongString(String var1, B var2);

    default public void writeUuid(UUID uuid, B dest) {
        this.writeLong(uuid.getMostSignificantBits(), dest);
        this.writeLong(uuid.getLeastSignificantBits(), dest);
    }

    public void writeBytes(ByteBuffer var1, B var2);

    public void writeShortBytes(byte[] var1, B var2);

    default public void writeStringList(List<String> l, B dest) {
        this.writeUnsignedShort(l.size(), dest);
        for (String s : l) {
            this.writeString(s, dest);
        }
    }

    default public void writeStringMap(Map<String, String> m, B dest) {
        this.writeUnsignedShort(m.size(), dest);
        for (Map.Entry<String, String> entry : m.entrySet()) {
            this.writeString(entry.getKey(), dest);
            this.writeString(entry.getValue(), dest);
        }
    }

    default public void writeStringMultimap(Map<String, List<String>> m, B dest) {
        this.writeUnsignedShort(m.size(), dest);
        for (Map.Entry<String, List<String>> entry : m.entrySet()) {
            this.writeString(entry.getKey(), dest);
            this.writeStringList(entry.getValue(), dest);
        }
    }

    default public void writeBytesMap(Map<String, ByteBuffer> m, B dest) {
        this.writeUnsignedShort(m.size(), dest);
        for (Map.Entry<String, ByteBuffer> entry : m.entrySet()) {
            this.writeString(entry.getKey(), dest);
            this.writeBytes(entry.getValue(), dest);
        }
    }

    default public void writeInet(InetSocketAddress address, B dest) {
        this.writeInetAddr(address.getAddress(), dest);
        this.writeInt(address.getPort(), dest);
    }
}

