/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.result;

import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.result.ColumnSpec;
import com.datastax.oss.protocol.internal.response.result.RawType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;

public class RowsMetadata {
    public final List<ColumnSpec> columnSpecs;
    public final int columnCount;
    public final ByteBuffer pagingState;
    public final int[] pkIndices;
    private final EnumSet<Flag> flags;

    public RowsMetadata(List<ColumnSpec> columnSpecs, ByteBuffer pagingState, int[] pkIndices) {
        this(columnSpecs, columnSpecs.size(), false, pagingState, pkIndices);
    }

    public RowsMetadata(int columnCount, ByteBuffer pagingState, int[] pkIndices) {
        this(Collections.emptyList(), columnCount, true, pagingState, pkIndices);
    }

    private RowsMetadata(List<ColumnSpec> columnSpecs, int columnCount, boolean noMetadata, ByteBuffer pagingState, int[] pkIndices) {
        this(RowsMetadata.computeFlags(noMetadata, columnSpecs, pagingState), columnSpecs, columnCount, pagingState, pkIndices);
    }

    private RowsMetadata(EnumSet<Flag> flags, List<ColumnSpec> columnSpecs, int columnCount, ByteBuffer pagingState, int[] pkIndices) {
        this.columnSpecs = columnSpecs;
        this.columnCount = columnCount;
        this.pagingState = pagingState;
        this.pkIndices = pkIndices;
        this.flags = flags;
    }

    private static EnumSet<Flag> computeFlags(boolean noMetadata, List<ColumnSpec> columnSpecs, ByteBuffer pagingState) {
        EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
        if (noMetadata) {
            flags.add(Flag.NO_METADATA);
        } else if (RowsMetadata.haveSameTable(columnSpecs)) {
            flags.add(Flag.GLOBAL_TABLES_SPEC);
        }
        if (pagingState != null) {
            flags.add(Flag.HAS_MORE_PAGES);
        }
        return flags;
    }

    public <B> void encode(B dest, PrimitiveCodec<B> encoder, boolean withPkIndices, int protocolVersion) {
        Flag.encode(this.flags, dest, encoder, protocolVersion);
        encoder.writeInt(this.columnCount, dest);
        if (withPkIndices) {
            if (this.pkIndices == null) {
                encoder.writeInt(0, dest);
            } else {
                encoder.writeInt(this.pkIndices.length, dest);
                for (int pkIndex : this.pkIndices) {
                    encoder.writeUnsignedShort(pkIndex, dest);
                }
            }
        }
        if (this.flags.contains((Object)Flag.HAS_MORE_PAGES)) {
            encoder.writeBytes(this.pagingState, dest);
        }
        if (!this.flags.contains((Object)Flag.NO_METADATA) && !this.columnSpecs.isEmpty()) {
            boolean globalTable = this.flags.contains((Object)Flag.GLOBAL_TABLES_SPEC);
            if (globalTable) {
                ColumnSpec firstSpec = this.columnSpecs.get(0);
                encoder.writeString(firstSpec.ksName, dest);
                encoder.writeString(firstSpec.tableName, dest);
            }
            for (ColumnSpec spec : this.columnSpecs) {
                if (!globalTable) {
                    encoder.writeString(spec.ksName, dest);
                    encoder.writeString(spec.tableName, dest);
                }
                encoder.writeString(spec.name, dest);
                spec.type.encode(dest, encoder, protocolVersion);
            }
        }
    }

    public int encodedSize(boolean withPkIndices, int protocolVersion) {
        int size = Flag.encodedSize(protocolVersion);
        size += 4;
        if (withPkIndices) {
            size += 4;
            if (this.pkIndices != null) {
                size += this.pkIndices.length * 2;
            }
        }
        if (this.flags.contains((Object)Flag.HAS_MORE_PAGES)) {
            size += PrimitiveSizes.sizeOfBytes(this.pagingState);
        }
        if (!this.flags.contains((Object)Flag.NO_METADATA) && !this.columnSpecs.isEmpty()) {
            boolean globalTable = this.flags.contains((Object)Flag.GLOBAL_TABLES_SPEC);
            if (globalTable) {
                ColumnSpec firstSpec = this.columnSpecs.get(0);
                size += PrimitiveSizes.sizeOfString(firstSpec.ksName);
                size += PrimitiveSizes.sizeOfString(firstSpec.tableName);
            }
            for (ColumnSpec spec : this.columnSpecs) {
                if (!globalTable) {
                    size += PrimitiveSizes.sizeOfString(spec.ksName);
                    size += PrimitiveSizes.sizeOfString(spec.tableName);
                }
                size += PrimitiveSizes.sizeOfString(spec.name);
                size += spec.type.encodedSize(protocolVersion);
            }
        }
        return size;
    }

    public static <B> RowsMetadata decode(B source, PrimitiveCodec<B> decoder, boolean withPkIndices, int protocolVersion) {
        List<ColumnSpec> columnSpecs;
        ByteBuffer state;
        int pkCount;
        EnumSet<Flag> flags = Flag.decode(source, decoder, protocolVersion);
        int columnCount = decoder.readInt(source);
        int[] pkIndices = null;
        if (withPkIndices && (pkCount = decoder.readInt(source)) > 0) {
            pkIndices = new int[pkCount];
            for (int i = 0; i < pkCount; ++i) {
                pkIndices[i] = decoder.readUnsignedShort(source);
            }
        }
        ByteBuffer byteBuffer = state = flags.contains((Object)Flag.HAS_MORE_PAGES) ? decoder.readBytes(source) : null;
        if (flags.contains((Object)Flag.NO_METADATA)) {
            columnSpecs = Collections.emptyList();
        } else {
            boolean globalTablesSpec = flags.contains((Object)Flag.GLOBAL_TABLES_SPEC);
            String globalKsName = null;
            String globalCfName = null;
            if (globalTablesSpec) {
                globalKsName = decoder.readString(source);
                globalCfName = decoder.readString(source);
            }
            ArrayList<ColumnSpec> tmpSpecs = new ArrayList<ColumnSpec>(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                String ksName = globalTablesSpec ? globalKsName : decoder.readString(source);
                String cfName = globalTablesSpec ? globalCfName : decoder.readString(source);
                String name = decoder.readString(source);
                RawType type = RawType.decode(source, decoder, protocolVersion);
                tmpSpecs.add(new ColumnSpec(ksName, cfName, name, i, type));
            }
            columnSpecs = Collections.unmodifiableList(tmpSpecs);
        }
        return new RowsMetadata(flags, columnSpecs, columnCount, state, pkIndices);
    }

    private static boolean haveSameTable(List<ColumnSpec> specs) {
        if (specs.isEmpty()) {
            return false;
        }
        boolean first = true;
        String ksName = null;
        String tableName = null;
        for (ColumnSpec spec : specs) {
            if (first) {
                first = false;
                ksName = spec.ksName;
                tableName = spec.tableName;
                continue;
            }
            if (Objects.equals(spec.ksName, ksName) && Objects.equals(spec.tableName, tableName)) continue;
            return false;
        }
        return true;
    }

    private static enum Flag {
        GLOBAL_TABLES_SPEC(1),
        HAS_MORE_PAGES(2),
        NO_METADATA(4);

        private final int mask;

        private Flag(int mask) {
            this.mask = mask;
        }

        public static <B> EnumSet<Flag> decode(B source, PrimitiveCodec<B> decoder, int protocolVersion) {
            int bits = decoder.readInt(source);
            EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
            for (Flag flag : Flag.values()) {
                if ((bits & flag.mask) == 0) continue;
                set.add(flag);
            }
            return set;
        }

        public static <B> void encode(EnumSet<Flag> flags, B dest, PrimitiveCodec<B> encoder, int protocolVersion) {
            int bits = 0;
            for (Flag flag : flags) {
                bits |= flag.mask;
            }
            encoder.writeInt(bits, dest);
        }

        public static int encodedSize(int protocolVersion) {
            return 4;
        }
    }
}

