/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.request;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.request.query.QueryOptions;

public class Query
extends Message {
    public final String query;
    public final QueryOptions options;

    public Query(String query, QueryOptions options) {
        super(false, 7);
        this.query = query;
        this.options = options;
    }

    public Query(String query) {
        this(query, QueryOptions.DEFAULT);
    }

    public String toString() {
        return "QUERY (" + this.query + ')';
    }

    public static class Codec
    extends Message.Codec {
        public Codec(int protocolVersion) {
            super(7, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder) {
            Query query = (Query)message;
            encoder.writeLongString(query.query, dest);
            query.options.encode(dest, encoder, this.protocolVersion);
        }

        @Override
        public int encodedSize(Message message) {
            Query query = (Query)message;
            return PrimitiveSizes.sizeOfLongString(query.query) + query.options.encodedSize(this.protocolVersion);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder) {
            String query = decoder.readLongString(source);
            QueryOptions options = QueryOptions.decode(source, decoder, this.protocolVersion);
            return new Query(query, options);
        }
    }
}

