/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.mapping.AccessorMapper;
import com.datastax.driver.mapping.MethodMapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class AccessorInvocationHandler<T>
implements InvocationHandler {
    private static final Object[] NO_ARGS = new Object[0];
    private final AccessorMapper<T> mapper;
    private final Map<Method, MethodMapper> methodMap = new HashMap<Method, MethodMapper>();

    AccessorInvocationHandler(AccessorMapper<T> mapper) {
        this.mapper = mapper;
        for (MethodMapper method : mapper.methods) {
            this.methodMap.put(method.method, method);
        }
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        MethodMapper method = this.methodMap.get(m);
        if (this.mapper == null) {
            throw new UnsupportedOperationException();
        }
        return method.invoke(args == null ? NO_ARGS : args);
    }
}

