/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.stdlib.json;

import com.datasqrl.flinkrunner.stdlib.json.FlinkJsonType;
import com.datasqrl.flinkrunner.stdlib.utils.AutoRegisterSystemFunction;
import com.google.auto.service.AutoService;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.InputGroup;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.types.Row;
import org.apache.flink.util.jackson.JacksonMapperFactory;

@AutoService(value={AutoRegisterSystemFunction.class})
public class to_jsonb
extends ScalarFunction
implements AutoRegisterSystemFunction {
    public static final ObjectMapper mapper = JacksonMapperFactory.createObjectMapper();

    public FlinkJsonType eval(String json) {
        if (json == null) {
            return null;
        }
        try {
            return new FlinkJsonType(mapper.readTree(json));
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public FlinkJsonType eval(@DataTypeHint(inputGroup=InputGroup.ANY) Object json) {
        if (json == null) {
            return null;
        }
        if (json instanceof FlinkJsonType) {
            return (FlinkJsonType)json;
        }
        return new FlinkJsonType(this.unboxFlinkToJsonNode(json));
    }

    JsonNode unboxFlinkToJsonNode(Object json) {
        if (json instanceof Row) {
            String[] fieldNames;
            Row row = (Row)json;
            ObjectNode objectNode = mapper.createObjectNode();
            for (String fieldName : fieldNames = row.getFieldNames(true).toArray(new String[0])) {
                Object field = row.getField(fieldName);
                objectNode.set(fieldName, this.unboxFlinkToJsonNode(field));
            }
            return objectNode;
        }
        if (json instanceof Row[]) {
            Row[] rows = (Row[])json;
            ArrayNode arrayNode = mapper.createArrayNode();
            for (Row row : rows) {
                if (row == null) {
                    arrayNode.addNull();
                    continue;
                }
                arrayNode.add(this.unboxFlinkToJsonNode(row));
            }
            return arrayNode;
        }
        return mapper.valueToTree(json);
    }
}

