/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.stdlib.json;

import com.datasqrl.flinkrunner.stdlib.json.FlinkJsonType;
import com.datasqrl.flinkrunner.stdlib.json.FlinkJsonTypeSerializer;
import com.datasqrl.flinkrunner.stdlib.json.ObjectAgg;
import com.datasqrl.flinkrunner.stdlib.utils.AutoRegisterSystemFunction;
import com.google.auto.service.AutoService;
import java.util.LinkedHashMap;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.annotation.InputGroup;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.util.jackson.JacksonMapperFactory;

@FunctionHint(output=@DataTypeHint(value="RAW", bridgedTo=FlinkJsonType.class, rawSerializer=FlinkJsonTypeSerializer.class))
@AutoService(value={AutoRegisterSystemFunction.class})
public class jsonb_object_agg
extends AggregateFunction<Object, ObjectAgg>
implements AutoRegisterSystemFunction {
    private static final ObjectMapper mapper = JacksonMapperFactory.createObjectMapper();

    public ObjectAgg createAccumulator() {
        return new ObjectAgg(new LinkedHashMap<String, JsonNode>());
    }

    public void accumulate(ObjectAgg accumulator, String key, String value) {
        this.accumulateObject(accumulator, key, value);
    }

    public void accumulate(ObjectAgg accumulator, String key, @DataTypeHint(inputGroup=InputGroup.ANY) Object value) {
        if (value instanceof FlinkJsonType) {
            this.accumulateObject(accumulator, key, ((FlinkJsonType)value).getJson());
        } else {
            accumulator.add(key, (JsonNode)mapper.getNodeFactory().pojoNode(value));
        }
    }

    public void accumulate(ObjectAgg accumulator, String key, Double value) {
        this.accumulateObject(accumulator, key, value);
    }

    public void accumulate(ObjectAgg accumulator, String key, Long value) {
        this.accumulateObject(accumulator, key, value);
    }

    public void accumulate(ObjectAgg accumulator, String key, Integer value) {
        this.accumulateObject(accumulator, key, value);
    }

    public void accumulateObject(ObjectAgg accumulator, String key, Object value) {
        accumulator.add(key, (JsonNode)mapper.getNodeFactory().pojoNode(value));
    }

    public void retract(ObjectAgg accumulator, String key, String value) {
        this.retractObject(accumulator, key);
    }

    public void retract(ObjectAgg accumulator, String key, @DataTypeHint(inputGroup=InputGroup.ANY) Object value) {
        this.retractObject(accumulator, key);
    }

    public void retract(ObjectAgg accumulator, String key, Double value) {
        this.retractObject(accumulator, key);
    }

    public void retract(ObjectAgg accumulator, String key, Long value) {
        this.retractObject(accumulator, key);
    }

    public void retract(ObjectAgg accumulator, String key, Integer value) {
        this.retractObject(accumulator, key);
    }

    public void retractObject(ObjectAgg accumulator, String key) {
        accumulator.remove(key);
    }

    public void merge(ObjectAgg accumulator, Iterable<ObjectAgg> iterable) {
        iterable.forEach(o -> accumulator.getObjects().putAll(o.getObjects()));
    }

    public FlinkJsonType getValue(ObjectAgg accumulator) {
        ObjectNode objectNode = mapper.createObjectNode();
        accumulator.getObjects().forEach((arg_0, arg_1) -> ((ObjectNode)objectNode).putPOJO(arg_0, arg_1));
        return new FlinkJsonType((JsonNode)objectNode);
    }
}

