/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.stdlib.json;

import com.datasqrl.flinkrunner.stdlib.json.FlinkJsonType;
import com.datasqrl.flinkrunner.stdlib.json.JsonFunctions;
import com.datasqrl.flinkrunner.stdlib.utils.AutoRegisterSystemFunction;
import com.google.auto.service.AutoService;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.util.jackson.JacksonMapperFactory;

@AutoService(value={AutoRegisterSystemFunction.class})
public class jsonb_object
extends ScalarFunction
implements AutoRegisterSystemFunction {
    static final ObjectMapper mapper = JacksonMapperFactory.createObjectMapper();

    public FlinkJsonType eval(Object ... objects) {
        if (objects.length % 2 != 0) {
            throw new IllegalArgumentException("Arguments should be in key-value pairs");
        }
        ObjectNode objectNode = mapper.createObjectNode();
        for (int i = 0; i < objects.length; i += 2) {
            if (!(objects[i] instanceof String)) {
                throw new IllegalArgumentException("Key must be a string");
            }
            String key = (String)objects[i];
            Object value = objects[i + 1];
            if (value instanceof FlinkJsonType) {
                objectNode.put(key, ((FlinkJsonType)value).json);
                continue;
            }
            objectNode.putPOJO(key, value);
        }
        return new FlinkJsonType((JsonNode)objectNode);
    }

    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        InputTypeStrategy anyJsonCompatibleArg = InputTypeStrategies.repeatingSequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{JsonFunctions.createJsonArgumentTypeStrategy(typeFactory)});
        InputTypeStrategy inputTypeStrategy = InputTypeStrategies.compositeSequence().finishWithVarying(anyJsonCompatibleArg);
        return TypeInference.newBuilder().inputTypeStrategy(inputTypeStrategy).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.of(FlinkJsonType.class).toDataType(typeFactory))).build();
    }
}

