/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.stdlib.json;

import com.datasqrl.flinkrunner.stdlib.json.ArrayAgg;
import com.datasqrl.flinkrunner.stdlib.json.FlinkJsonType;
import com.datasqrl.flinkrunner.stdlib.utils.AutoRegisterSystemFunction;
import com.google.auto.service.AutoService;
import java.util.ArrayList;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.util.jackson.JacksonMapperFactory;

@AutoService(value={AutoRegisterSystemFunction.class})
public class jsonb_array_agg
extends AggregateFunction<FlinkJsonType, ArrayAgg>
implements AutoRegisterSystemFunction {
    private static final ObjectMapper mapper = JacksonMapperFactory.createObjectMapper();

    public ArrayAgg createAccumulator() {
        return new ArrayAgg(new ArrayList<JsonNode>());
    }

    public void accumulate(ArrayAgg accumulator, String value) {
        accumulator.add((JsonNode)mapper.getNodeFactory().textNode(value));
    }

    public void accumulate(ArrayAgg accumulator, FlinkJsonType value) {
        if (value != null) {
            accumulator.add(value.json);
        } else {
            accumulator.add(null);
        }
    }

    public void accumulate(ArrayAgg accumulator, Double value) {
        accumulator.add((JsonNode)mapper.getNodeFactory().numberNode(value));
    }

    public void accumulate(ArrayAgg accumulator, Long value) {
        accumulator.add((JsonNode)mapper.getNodeFactory().numberNode(value));
    }

    public void accumulate(ArrayAgg accumulator, Integer value) {
        accumulator.add((JsonNode)mapper.getNodeFactory().numberNode(value));
    }

    public void retract(ArrayAgg accumulator, String value) {
        accumulator.remove((JsonNode)mapper.getNodeFactory().textNode(value));
    }

    public void retract(ArrayAgg accumulator, FlinkJsonType value) {
        if (value != null) {
            accumulator.remove(value.json);
        } else {
            accumulator.remove(null);
        }
    }

    public void retract(ArrayAgg accumulator, Double value) {
        accumulator.remove((JsonNode)mapper.getNodeFactory().numberNode(value));
    }

    public void retract(ArrayAgg accumulator, Long value) {
        accumulator.remove((JsonNode)mapper.getNodeFactory().numberNode(value));
    }

    public void retract(ArrayAgg accumulator, Integer value) {
        accumulator.remove((JsonNode)mapper.getNodeFactory().numberNode(value));
    }

    public void merge(ArrayAgg accumulator, Iterable<ArrayAgg> iterable) {
        iterable.forEach(o -> accumulator.getObjects().addAll(o.getObjects()));
    }

    public FlinkJsonType getValue(ArrayAgg accumulator) {
        ArrayNode arrayNode = mapper.createArrayNode();
        for (JsonNode o : accumulator.getObjects()) {
            if (o instanceof FlinkJsonType) {
                arrayNode.add(((FlinkJsonType)o).json);
                continue;
            }
            arrayNode.addPOJO((Object)o);
        }
        return new FlinkJsonType((JsonNode)arrayNode);
    }
}

