/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.AlphaNumericMessage;
import com.timgroup.statsd.BufferPool;
import com.timgroup.statsd.CgroupReader;
import com.timgroup.statsd.ClientChannel;
import com.timgroup.statsd.DatagramClientChannel;
import com.timgroup.statsd.Event;
import com.timgroup.statsd.Message;
import com.timgroup.statsd.NamedPipeClientChannel;
import com.timgroup.statsd.NamedPipeSocketAddress;
import com.timgroup.statsd.NonBlockingStatsDClientBuilder;
import com.timgroup.statsd.NumericMessage;
import com.timgroup.statsd.ServiceCheck;
import com.timgroup.statsd.StatsDBlockingProcessor;
import com.timgroup.statsd.StatsDClient;
import com.timgroup.statsd.StatsDClientErrorHandler;
import com.timgroup.statsd.StatsDClientException;
import com.timgroup.statsd.StatsDNonBlockingProcessor;
import com.timgroup.statsd.StatsDProcessor;
import com.timgroup.statsd.StatsDSender;
import com.timgroup.statsd.StatsDThreadFactory;
import com.timgroup.statsd.TagsCardinality;
import com.timgroup.statsd.Telemetry;
import com.timgroup.statsd.UnixDatagramClientChannel;
import com.timgroup.statsd.UnixSocketAddressWithTransport;
import com.timgroup.statsd.UnixStreamClientChannel;
import com.timgroup.statsd.Utf8;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;

public class NonBlockingStatsDClient
implements StatsDClient {
    public static final String DD_DOGSTATSD_PORT_ENV_VAR = "DD_DOGSTATSD_PORT";
    public static final String DD_AGENT_HOST_ENV_VAR = "DD_AGENT_HOST";
    public static final String DD_NAMED_PIPE_ENV_VAR = "DD_DOGSTATSD_PIPE_NAME";
    public static final String DD_ENTITY_ID_ENV_VAR = "DD_ENTITY_ID";
    private static final String ENTITY_ID_TAG_NAME = "dd.internal.entity_id";
    public static final String ORIGIN_DETECTION_ENABLED_ENV_VAR = "DD_ORIGIN_DETECTION_ENABLED";
    public static final String DD_DOGSTATSD_URL_ENV_VAR = "DD_DOGSTATSD_URL";
    private static final long MIN_TIMESTAMP = 1L;
    public static final int DEFAULT_UDP_MAX_PACKET_SIZE_BYTES = 1432;
    public static final int DEFAULT_UDS_MAX_PACKET_SIZE_BYTES = 8192;
    public static final int DEFAULT_QUEUE_SIZE = 4096;
    public static final int DEFAULT_POOL_SIZE = 512;
    public static final int DEFAULT_PROCESSOR_WORKERS = 1;
    public static final int DEFAULT_SENDER_WORKERS = 1;
    public static final int DEFAULT_DOGSTATSD_PORT = 8125;
    public static final int SOCKET_TIMEOUT_MS = 100;
    public static final int SOCKET_BUFFER_BYTES = -1;
    public static final boolean DEFAULT_BLOCKING = false;
    public static final boolean DEFAULT_ENABLE_TELEMETRY = true;
    public static final boolean DEFAULT_ENABLE_AGGREGATION = true;
    public static final boolean DEFAULT_ENABLE_ORIGIN_DETECTION = true;
    public static final int SOCKET_CONNECT_TIMEOUT_MS = 1000;
    public static final String CLIENT_TAG = "client:java";
    public static final String CLIENT_VERSION_TAG = "client_version:";
    public static final String CLIENT_TRANSPORT_TAG = "client_transport:";
    public static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final StatsDClientErrorHandler NO_OP_HANDLER = new StatsDClientErrorHandler(){

        @Override
        public void handle(Exception ex) {
        }
    };
    protected static final ThreadLocal<NumberFormat> NUMBER_FORMATTER = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return NonBlockingStatsDClient.newFormatter(false);
        }
    };
    protected static final ThreadLocal<NumberFormat> SAMPLE_RATE_FORMATTER = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return NonBlockingStatsDClient.newFormatter(true);
        }
    };
    final String prefix;
    private final ClientChannel clientChannel;
    private final ClientChannel telemetryClientChannel;
    private final StatsDClientErrorHandler handler;
    private final String constantTagsRendered;
    protected final StatsDProcessor statsDProcessor;
    protected StatsDProcessor telemetryStatsDProcessor;
    protected final StatsDSender statsDSender;
    protected StatsDSender telemetryStatsDSender;
    protected final Telemetry telemetry;
    final String telemetryTags;
    private final int maxPacketSizeBytes;
    private final boolean blocking;
    private final String containerID;
    private final String externalEnv;
    final TagsCardinality clientTagsCardinality;

    private static NumberFormat newFormatter(boolean sampler) {
        NumberFormat numberFormatter = NumberFormat.getInstance(Locale.US);
        numberFormatter.setGroupingUsed(false);
        if (numberFormatter instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)numberFormatter;
            DecimalFormatSymbols symbols = decimalFormat.getDecimalFormatSymbols();
            symbols.setNaN("NaN");
            decimalFormat.setDecimalFormatSymbols(symbols);
        }
        if (sampler) {
            numberFormatter.setMinimumFractionDigits(6);
        } else {
            numberFormatter.setMaximumFractionDigits(6);
        }
        return numberFormatter;
    }

    protected static String format(ThreadLocal<NumberFormat> formatter, Number value) {
        return formatter.get().format(value);
    }

    public NonBlockingStatsDClient(NonBlockingStatsDClientBuilder builder) throws StatsDClientException {
        this.prefix = builder.prefix != null && !builder.prefix.isEmpty() ? builder.prefix + "." : "";
        this.handler = builder.errorHandler == null ? NO_OP_HANDLER : builder.errorHandler;
        this.blocking = builder.blocking;
        this.maxPacketSizeBytes = builder.maxPacketSizeBytes;
        this.clientTagsCardinality = builder.tagsCardinality;
        ArrayList<String> constantPreTags = new ArrayList<String>();
        if (builder.constantTags != null) {
            for (String string : builder.constantTags) {
                constantPreTags.add(string);
            }
        }
        NonBlockingStatsDClient.updateTagsWithEntityID(constantPreTags, builder.entityID);
        for (Literal literal : Literal.values()) {
            String envVal = literal.envVal();
            if (envVal == null || envVal.trim().isEmpty()) continue;
            constantPreTags.add(literal.tag() + ":" + envVal);
        }
        this.constantTagsRendered = constantPreTags.isEmpty() ? null : NonBlockingStatsDClient.tagString(constantPreTags.toArray(new String[constantPreTags.size()]), null, new StringBuilder()).toString();
        constantPreTags = null;
        boolean originDetectionEnabled = NonBlockingStatsDClient.isOriginDetectionEnabled(builder.originDetectionEnabled);
        this.containerID = NonBlockingStatsDClient.getContainerID(builder.containerID, originDetectionEnabled);
        this.externalEnv = originDetectionEnabled ? Utf8.sanitize(System.getenv("DD_EXTERNAL_ENV")) : "";
        try {
            this.clientChannel = this.createByteChannel(builder.addressLookup, builder.timeout, builder.connectionTimeout, builder.socketBufferSize);
            ThreadFactory threadFactory = builder.threadFactory != null ? builder.threadFactory : new StatsDThreadFactory();
            int aggregationFlushInterval = builder.enableAggregation ? builder.aggregationFlushInterval : 0;
            this.statsDProcessor = this.createProcessor(builder.queueSize, this.handler, this.getPacketSize(this.clientChannel), builder.bufferPoolSize, builder.processorWorkers, builder.blocking, aggregationFlushInterval, builder.aggregationShards, threadFactory);
            Properties properties = new Properties();
            properties.load(this.getClass().getClassLoader().getResourceAsStream("dogstatsd/version.properties"));
            this.telemetryTags = this.tagString(new String[]{CLIENT_TRANSPORT_TAG + this.clientChannel.getTransportType(), CLIENT_VERSION_TAG + properties.getProperty("dogstatsd_client_version"), CLIENT_TAG}, new StringBuilder()).toString();
            if (builder.addressLookup == builder.telemetryAddressLookup) {
                this.telemetryClientChannel = this.clientChannel;
                this.telemetryStatsDProcessor = this.statsDProcessor;
            } else {
                this.telemetryClientChannel = this.createByteChannel(builder.telemetryAddressLookup, builder.timeout, builder.connectionTimeout, builder.socketBufferSize);
                this.telemetryStatsDProcessor = this.createProcessor(builder.queueSize, this.handler, this.getPacketSize(this.telemetryClientChannel), builder.bufferPoolSize, 1, false, 0, builder.aggregationShards, threadFactory);
            }
            this.telemetry = new Telemetry(this);
            this.telemetryStatsDSender = this.statsDSender = this.createSender(this.handler, this.clientChannel, this.statsDProcessor.getBufferPool(), this.statsDProcessor.getOutboundQueue(), builder.senderWorkers, threadFactory);
            if (this.telemetryStatsDProcessor != this.statsDProcessor) {
                this.telemetryStatsDSender = this.createSender(this.handler, this.telemetryClientChannel, this.telemetryStatsDProcessor.getBufferPool(), this.telemetryStatsDProcessor.getOutboundQueue(), 1, threadFactory);
            }
            this.statsDProcessor.setTelemetry(this.telemetry);
            this.statsDSender.setTelemetry(this.telemetry);
        }
        catch (Exception exception) {
            throw new StatsDClientException("Failed to start StatsD client", exception);
        }
        this.statsDProcessor.startWorkers("StatsD-Processor-");
        this.statsDSender.startWorkers("StatsD-Sender-");
        if (builder.enableTelemetry) {
            if (this.telemetryStatsDProcessor != this.statsDProcessor) {
                this.telemetryStatsDProcessor.startWorkers("StatsD-TelemetryProcessor-");
                this.telemetryStatsDSender.startWorkers("StatsD-TelemetrySender-");
            }
            this.telemetry.start(builder.telemetryFlushInterval);
        }
    }

    protected StatsDProcessor createProcessor(int queueSize, StatsDClientErrorHandler handler, int maxPacketSizeBytes, int bufferPoolSize, int workers, boolean blocking, int aggregationFlushInterval, int aggregationShards, ThreadFactory threadFactory) throws Exception {
        if (blocking) {
            return new StatsDBlockingProcessor(queueSize, handler, maxPacketSizeBytes, bufferPoolSize, workers, aggregationFlushInterval, aggregationShards, threadFactory);
        }
        return new StatsDNonBlockingProcessor(queueSize, handler, maxPacketSizeBytes, bufferPoolSize, workers, aggregationFlushInterval, aggregationShards, threadFactory);
    }

    protected StatsDSender createSender(StatsDClientErrorHandler handler, WritableByteChannel clientChannel, BufferPool pool, BlockingQueue<ByteBuffer> buffers, int senderWorkers, ThreadFactory threadFactory) throws Exception {
        return new StatsDSender(clientChannel, handler, pool, buffers, senderWorkers, threadFactory);
    }

    @Override
    public void stop() {
        try {
            this.telemetry.stop();
            this.statsDProcessor.shutdown(this.blocking);
            this.statsDSender.shutdown(this.blocking);
            if (this.telemetryStatsDProcessor != this.statsDProcessor) {
                this.telemetryStatsDProcessor.shutdown(false);
                this.telemetryStatsDSender.shutdown(false);
            }
        }
        catch (Exception e) {
            this.handler.handle(e);
        }
        finally {
            if (this.clientChannel != null) {
                try {
                    this.clientChannel.close();
                }
                catch (IOException e) {
                    this.handler.handle(e);
                }
            }
            if (this.telemetryClientChannel != null && this.telemetryClientChannel != this.clientChannel) {
                try {
                    this.telemetryClientChannel.close();
                }
                catch (IOException e) {
                    this.handler.handle(e);
                }
            }
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    static StringBuilder tagString(String[] tags, String tagPrefix, StringBuilder sb) {
        if (tagPrefix != null) {
            sb.append(tagPrefix);
            if (tags == null || tags.length == 0) {
                return sb;
            }
            sb.append(',');
        } else {
            if (tags == null || tags.length == 0) {
                return sb;
            }
            sb.append("|#");
        }
        for (int n = tags.length - 1; n >= 0; --n) {
            sb.append(tags[n]);
            if (n <= 0) continue;
            sb.append(',');
        }
        return sb;
    }

    StringBuilder tagString(String[] tags, StringBuilder builder) {
        return NonBlockingStatsDClient.tagString(tags, this.constantTagsRendered, builder);
    }

    ClientChannel createByteChannel(Callable<SocketAddress> addressLookup, int timeout, int connectionTimeout, int bufferSize) throws Exception {
        SocketAddress address = addressLookup.call();
        if (address instanceof NamedPipeSocketAddress) {
            return new NamedPipeClientChannel((NamedPipeSocketAddress)address);
        }
        if (address instanceof UnixSocketAddressWithTransport) {
            UnixSocketAddressWithTransport unixAddr = (UnixSocketAddressWithTransport)address;
            switch (unixAddr.getTransportType()) {
                case UDS_STREAM: {
                    return new UnixStreamClientChannel(unixAddr.getAddress(), timeout, connectionTimeout, bufferSize);
                }
                case UDS_DATAGRAM: 
                case UDS: {
                    return new UnixDatagramClientChannel(unixAddr.getAddress(), timeout, bufferSize);
                }
            }
            throw new IllegalArgumentException("Unsupported transport type: " + (Object)((Object)unixAddr.getTransportType()));
        }
        try {
            if (Class.forName("jnr.unixsocket.UnixSocketAddress").isInstance(address)) {
                return new UnixDatagramClientChannel(address, timeout, bufferSize);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return new DatagramClientChannel(address);
    }

    void writeMessageTail(StringBuilder builder, TagsCardinality msgTagsCardinality) {
        if (msgTagsCardinality.value != null) {
            builder.append("|card:").append(msgTagsCardinality.value);
        }
        if (this.containerID != null && !this.containerID.isEmpty()) {
            builder.append("|c:").append(this.containerID);
        }
        if (this.externalEnv != null && !this.externalEnv.isEmpty()) {
            builder.append("|e:").append(this.externalEnv);
        }
        builder.append('\n');
    }

    boolean sendMetric(Message message) {
        return this.send(message);
    }

    private boolean send(Message message) {
        boolean success = this.statsDProcessor.send(message);
        if (success) {
            this.telemetry.incrMetricsSent(1, message.getType());
        } else {
            this.telemetry.incrPacketDroppedQueue(1);
        }
        return success;
    }

    private void send(String aspect, double value, Message.Type type, double sampleRate, long timestamp, TagsCardinality cardinality, String[] tags) {
        if (this.statsDProcessor.getAggregator().getFlushInterval() != 0L && !Double.isNaN(sampleRate)) {
            switch (type) {
                case COUNT: {
                    sampleRate = Double.NaN;
                    break;
                }
            }
        }
        if (cardinality == null) {
            cardinality = this.clientTagsCardinality;
        }
        if (Double.isNaN(sampleRate) || !this.isInvalidSample(sampleRate)) {
            this.sendMetric(new StatsDMessage<Double>(aspect, type, Double.valueOf(value), sampleRate, timestamp, cardinality, tags){

                @Override
                protected void writeValue(StringBuilder builder) {
                    builder.append(NonBlockingStatsDClient.format(NUMBER_FORMATTER, this.value));
                }
            });
        }
    }

    private void send(String aspect, double value, Message.Type type, double sampleRate, TagsCardinality cardinality, String[] tags) {
        this.send(aspect, value, type, sampleRate, 0L, cardinality, tags);
    }

    private void send(String aspect, double value, Message.Type type, double sampleRate, String[] tags) {
        this.send(aspect, value, type, sampleRate, 0L, this.clientTagsCardinality, tags);
    }

    private void send(String aspect, double value, Message.Type type, String[] tags) {
        this.send(aspect, value, type, Double.NaN, 0L, this.clientTagsCardinality, tags);
    }

    private void send(String aspect, long value, Message.Type type, double sampleRate, long timestamp, TagsCardinality cardinality, String[] tags) {
        if (this.statsDProcessor.getAggregator().getFlushInterval() != 0L && !Double.isNaN(sampleRate)) {
            switch (type) {
                case COUNT: {
                    sampleRate = Double.NaN;
                    break;
                }
            }
        }
        if (cardinality == null) {
            cardinality = this.clientTagsCardinality;
        }
        if (Double.isNaN(sampleRate) || !this.isInvalidSample(sampleRate)) {
            this.sendMetric(new StatsDMessage<Long>(aspect, type, Long.valueOf(value), sampleRate, timestamp, cardinality, tags){

                @Override
                protected void writeValue(StringBuilder builder) {
                    builder.append(this.value.longValue());
                }
            });
        }
    }

    private void send(String aspect, long value, Message.Type type, double sampleRate, TagsCardinality cardinality, String[] tags) {
        this.send(aspect, value, type, sampleRate, 0L, cardinality, tags);
    }

    private void send(String aspect, long value, Message.Type type, double sampleRate, String[] tags) {
        this.send(aspect, value, type, sampleRate, 0L, this.clientTagsCardinality, tags);
    }

    private void send(String aspect, long value, Message.Type type, String[] tags) {
        this.send(aspect, value, type, Double.NaN, 0L, this.clientTagsCardinality, tags);
    }

    private void sendWithTimestamp(String aspect, double value, Message.Type type, long timestamp, String[] tags) {
        if (timestamp < 1L) {
            timestamp = 1L;
        }
        this.send(aspect, value, type, Double.NaN, timestamp, this.clientTagsCardinality, tags);
    }

    private void sendWithTimestamp(String aspect, double value, Message.Type type, long timestamp, TagsCardinality cardinality, String[] tags) {
        if (timestamp < 1L) {
            timestamp = 1L;
        }
        this.send(aspect, value, type, Double.NaN, timestamp, cardinality, tags);
    }

    private void sendWithTimestamp(String aspect, long value, Message.Type type, long timestamp, String[] tags) {
        if (timestamp < 1L) {
            timestamp = 1L;
        }
        this.send(aspect, value, type, Double.NaN, timestamp, this.clientTagsCardinality, tags);
    }

    private void sendWithTimestamp(String aspect, long value, Message.Type type, long timestamp, TagsCardinality cardinality, String[] tags) {
        if (timestamp < 1L) {
            timestamp = 1L;
        }
        this.send(aspect, value, type, Double.NaN, timestamp, cardinality, tags);
    }

    @Override
    public void count(String aspect, long delta, String ... tags) {
        this.send(aspect, delta, Message.Type.COUNT, tags);
    }

    @Override
    public void count(String aspect, long delta, double sampleRate, String ... tags) {
        this.send(aspect, delta, Message.Type.COUNT, sampleRate, tags);
    }

    @Override
    public void count(String aspect, long delta, double sampleRate, TagsCardinality cardinality, String ... tags) {
        this.send(aspect, delta, Message.Type.COUNT, sampleRate, cardinality, tags);
    }

    @Override
    public void count(String aspect, double delta, String ... tags) {
        this.send(aspect, delta, Message.Type.COUNT, tags);
    }

    @Override
    public void count(String aspect, double delta, double sampleRate, String ... tags) {
        this.send(aspect, delta, Message.Type.COUNT, sampleRate, tags);
    }

    @Override
    public void count(String aspect, double delta, double sampleRate, TagsCardinality cardinality, String ... tags) {
        this.send(aspect, delta, Message.Type.COUNT, sampleRate, cardinality, tags);
    }

    @Override
    public void countWithTimestamp(String aspect, long value, long timestamp, String ... tags) {
        this.sendWithTimestamp(aspect, value, Message.Type.COUNT, timestamp, tags);
    }

    @Override
    public void countWithTimestamp(String aspect, long value, long timestamp, TagsCardinality cardinality, String ... tags) {
        this.sendWithTimestamp(aspect, value, Message.Type.COUNT, timestamp, cardinality, tags);
    }

    @Override
    public void countWithTimestamp(String aspect, double value, long timestamp, String ... tags) {
        this.sendWithTimestamp(aspect, value, Message.Type.COUNT, timestamp, tags);
    }

    @Override
    public void countWithTimestamp(String aspect, double value, long timestamp, TagsCardinality cardinality, String ... tags) {
        this.sendWithTimestamp(aspect, value, Message.Type.COUNT, timestamp, cardinality, tags);
    }

    @Override
    public void incrementCounter(String aspect, String ... tags) {
        this.count(aspect, 1L, tags);
    }

    @Override
    public void incrementCounter(String aspect, double sampleRate, String ... tags) {
        this.count(aspect, 1L, sampleRate, tags);
    }

    @Override
    public void increment(String aspect, String ... tags) {
        this.incrementCounter(aspect, tags);
    }

    @Override
    public void increment(String aspect, double sampleRate, String ... tags) {
        this.incrementCounter(aspect, sampleRate, tags);
    }

    @Override
    public void decrementCounter(String aspect, String ... tags) {
        this.count(aspect, -1L, tags);
    }

    @Override
    public void decrementCounter(String aspect, double sampleRate, String ... tags) {
        this.count(aspect, -1L, sampleRate, tags);
    }

    @Override
    public void decrement(String aspect, String ... tags) {
        this.decrementCounter(aspect, tags);
    }

    @Override
    public void decrement(String aspect, double sampleRate, String ... tags) {
        this.decrementCounter(aspect, sampleRate, tags);
    }

    @Override
    public void recordGaugeValue(String aspect, double value, String ... tags) {
        this.send(aspect, value, Message.Type.GAUGE, tags);
    }

    @Override
    public void recordGaugeValue(String aspect, double value, double sampleRate, String ... tags) {
        this.send(aspect, value, Message.Type.GAUGE, sampleRate, tags);
    }

    @Override
    public void recordGaugeValue(String aspect, double value, double sampleRate, TagsCardinality cardinality, String ... tags) {
        this.send(aspect, value, Message.Type.GAUGE, sampleRate, cardinality, tags);
    }

    @Override
    public void recordGaugeValue(String aspect, long value, String ... tags) {
        this.send(aspect, value, Message.Type.GAUGE, tags);
    }

    @Override
    public void recordGaugeValue(String aspect, long value, double sampleRate, String ... tags) {
        this.send(aspect, value, Message.Type.GAUGE, sampleRate, tags);
    }

    @Override
    public void recordGaugeValue(String aspect, long value, double sampleRate, TagsCardinality cardinality, String ... tags) {
        this.send(aspect, value, Message.Type.GAUGE, sampleRate, cardinality, tags);
    }

    @Override
    public void gauge(String aspect, double value, String ... tags) {
        this.recordGaugeValue(aspect, value, tags);
    }

    @Override
    public void gauge(String aspect, double value, double sampleRate, String ... tags) {
        this.recordGaugeValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void gauge(String aspect, double value, double sampleRate, TagsCardinality cardinality, String ... tags) {
        this.recordGaugeValue(aspect, value, sampleRate, cardinality, tags);
    }

    @Override
    public void gauge(String aspect, long value, String ... tags) {
        this.recordGaugeValue(aspect, value, tags);
    }

    @Override
    public void gauge(String aspect, long value, double sampleRate, String ... tags) {
        this.recordGaugeValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void gauge(String aspect, long value, double sampleRate, TagsCardinality cardinality, String ... tags) {
        this.recordGaugeValue(aspect, value, sampleRate, cardinality, tags);
    }

    @Override
    public void gaugeWithTimestamp(String aspect, double value, long timestamp, String ... tags) {
        this.sendWithTimestamp(aspect, value, Message.Type.GAUGE, timestamp, tags);
    }

    @Override
    public void gaugeWithTimestamp(String aspect, double value, long timestamp, TagsCardinality cardinality, String ... tags) {
        this.sendWithTimestamp(aspect, value, Message.Type.GAUGE, timestamp, cardinality, tags);
    }

    @Override
    public void gaugeWithTimestamp(String aspect, long value, long timestamp, String ... tags) {
        this.sendWithTimestamp(aspect, value, Message.Type.GAUGE, timestamp, tags);
    }

    @Override
    public void gaugeWithTimestamp(String aspect, long value, long timestamp, TagsCardinality cardinality, String ... tags) {
        this.sendWithTimestamp(aspect, value, Message.Type.GAUGE, timestamp, cardinality, tags);
    }

    @Override
    public void recordExecutionTime(String aspect, long timeInMs, String ... tags) {
        this.send(aspect, timeInMs, Message.Type.TIME, tags);
    }

    @Override
    public void recordExecutionTime(String aspect, long timeInMs, double sampleRate, String ... tags) {
        this.send(aspect, timeInMs, Message.Type.TIME, sampleRate, tags);
    }

    @Override
    public void recordExecutionTime(String aspect, long timeInMs, double sampleRate, TagsCardinality cardinality, String ... tags) {
        this.send(aspect, timeInMs, Message.Type.TIME, sampleRate, cardinality, tags);
    }

    @Override
    public void time(String aspect, long value, String ... tags) {
        this.recordExecutionTime(aspect, value, tags);
    }

    @Override
    public void time(String aspect, long value, double sampleRate, String ... tags) {
        this.recordExecutionTime(aspect, value, sampleRate, tags);
    }

    @Override
    public void time(String aspect, long value, double sampleRate, TagsCardinality cardinality, String ... tags) {
        this.recordExecutionTime(aspect, value, sampleRate, cardinality, tags);
    }

    @Override
    public void recordHistogramValue(String aspect, double value, String ... tags) {
        this.send(aspect, value, Message.Type.HISTOGRAM, tags);
    }

    @Override
    public void recordHistogramValue(String aspect, double value, double sampleRate, String ... tags) {
        this.send(aspect, value, Message.Type.HISTOGRAM, sampleRate, tags);
    }

    @Override
    public void recordHistogramValue(String aspect, double value, double sampleRate, TagsCardinality cardinality, String ... tags) {
        this.send(aspect, value, Message.Type.HISTOGRAM, sampleRate, cardinality, tags);
    }

    @Override
    public void recordHistogramValue(String aspect, long value, String ... tags) {
        this.send(aspect, value, Message.Type.HISTOGRAM, tags);
    }

    @Override
    public void recordHistogramValue(String aspect, long value, double sampleRate, String ... tags) {
        this.send(aspect, value, Message.Type.HISTOGRAM, sampleRate, tags);
    }

    @Override
    public void recordHistogramValue(String aspect, long value, double sampleRate, TagsCardinality cardinality, String ... tags) {
        this.send(aspect, value, Message.Type.HISTOGRAM, sampleRate, cardinality, tags);
    }

    @Override
    public void histogram(String aspect, double value, String ... tags) {
        this.recordHistogramValue(aspect, value, tags);
    }

    @Override
    public void histogram(String aspect, double value, double sampleRate, String ... tags) {
        this.recordHistogramValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void histogram(String aspect, double value, double sampleRate, TagsCardinality cardinality, String ... tags) {
        this.recordHistogramValue(aspect, value, sampleRate, cardinality, tags);
    }

    @Override
    public void histogram(String aspect, long value, String ... tags) {
        this.recordHistogramValue(aspect, value, tags);
    }

    @Override
    public void histogram(String aspect, long value, double sampleRate, String ... tags) {
        this.recordHistogramValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void histogram(String aspect, long value, double sampleRate, TagsCardinality cardinality, String ... tags) {
        this.recordHistogramValue(aspect, value, sampleRate, cardinality, tags);
    }

    @Override
    public void recordDistributionValue(String aspect, double value, String ... tags) {
        this.send(aspect, value, Message.Type.DISTRIBUTION, tags);
    }

    @Override
    public void recordDistributionValue(String aspect, double value, double sampleRate, String ... tags) {
        this.send(aspect, value, Message.Type.DISTRIBUTION, sampleRate, tags);
    }

    @Override
    public void recordDistributionValue(String aspect, double value, double sampleRate, TagsCardinality cardinality, String ... tags) {
        this.send(aspect, value, Message.Type.DISTRIBUTION, sampleRate, cardinality, tags);
    }

    @Override
    public void recordDistributionValue(String aspect, long value, String ... tags) {
        this.send(aspect, value, Message.Type.DISTRIBUTION, tags);
    }

    @Override
    public void recordDistributionValue(String aspect, long value, double sampleRate, String ... tags) {
        this.send(aspect, value, Message.Type.DISTRIBUTION, sampleRate, tags);
    }

    @Override
    public void recordDistributionValue(String aspect, long value, double sampleRate, TagsCardinality cardinality, String ... tags) {
        this.send(aspect, value, Message.Type.DISTRIBUTION, sampleRate, cardinality, tags);
    }

    @Override
    public void distribution(String aspect, double value, String ... tags) {
        this.recordDistributionValue(aspect, value, tags);
    }

    @Override
    public void distribution(String aspect, double value, double sampleRate, String ... tags) {
        this.recordDistributionValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void distribution(String aspect, double value, double sampleRate, TagsCardinality cardinality, String ... tags) {
        this.recordDistributionValue(aspect, value, sampleRate, cardinality, tags);
    }

    @Override
    public void distribution(String aspect, long value, String ... tags) {
        this.recordDistributionValue(aspect, value, tags);
    }

    @Override
    public void distribution(String aspect, long value, double sampleRate, String ... tags) {
        this.recordDistributionValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void distribution(String aspect, long value, double sampleRate, TagsCardinality cardinality, String ... tags) {
        this.recordDistributionValue(aspect, value, sampleRate, cardinality, tags);
    }

    private StringBuilder eventMap(Event event, StringBuilder res) {
        String sourceTypeName;
        String alertType;
        String priority;
        String aggregationKey;
        String hostname;
        long millisSinceEpoch = event.getMillisSinceEpoch();
        if (millisSinceEpoch != -1L) {
            res.append("|d:").append(millisSinceEpoch / 1000L);
        }
        if ((hostname = event.getHostname()) != null) {
            res.append("|h:").append(hostname);
        }
        if ((aggregationKey = event.getAggregationKey()) != null) {
            res.append("|k:").append(aggregationKey);
        }
        if ((priority = event.getPriority()) != null) {
            res.append("|p:").append(priority);
        }
        if ((alertType = event.getAlertType()) != null) {
            res.append("|t:").append(alertType);
        }
        if ((sourceTypeName = event.getSourceTypeName()) != null) {
            res.append("|s:").append(sourceTypeName);
        }
        return res;
    }

    @Override
    public void recordEvent(final Event event, final String ... eventTags) {
        TagsCardinality cardinality = event.getTagsCardinality();
        if (cardinality == null) {
            cardinality = this.clientTagsCardinality;
        }
        this.statsDProcessor.send(new AlphaNumericMessage(Message.Type.EVENT, "", cardinality){

            @Override
            public boolean writeTo(StringBuilder builder, int capacity) {
                String title = NonBlockingStatsDClient.escapeEventString(NonBlockingStatsDClient.this.prefix + event.getTitle());
                String text = NonBlockingStatsDClient.escapeEventString(event.getText());
                builder.append(Message.Type.EVENT.toString()).append("{").append(NonBlockingStatsDClient.this.getUtf8Length(title)).append(",").append(NonBlockingStatsDClient.this.getUtf8Length(text)).append("}:").append(title).append("|");
                if (text != null) {
                    builder.append(text);
                }
                NonBlockingStatsDClient.this.eventMap(event, builder);
                NonBlockingStatsDClient.this.tagString(eventTags, builder);
                NonBlockingStatsDClient.this.writeMessageTail(builder, this.tagsCardinality);
                return false;
            }
        });
        this.telemetry.incrEventsSent(1);
    }

    private static String escapeEventString(String title) {
        if (title == null) {
            return null;
        }
        return title.replace("\n", "\\n");
    }

    private int getUtf8Length(String text) {
        if (text == null) {
            return 0;
        }
        return text.getBytes(UTF_8).length;
    }

    @Override
    public void recordServiceCheckRun(final ServiceCheck sc) {
        TagsCardinality cardinality = sc.getTagsCardinality();
        if (cardinality == null) {
            cardinality = this.clientTagsCardinality;
        }
        this.statsDProcessor.send(new AlphaNumericMessage(Message.Type.SERVICE_CHECK, "", cardinality){

            @Override
            public boolean writeTo(StringBuilder sb, int capacity) {
                sb.append(Message.Type.SERVICE_CHECK.toString()).append("|").append(sc.getName()).append("|").append(sc.getStatus());
                if (sc.getTimestamp() > 0) {
                    sb.append("|d:").append(sc.getTimestamp());
                }
                if (sc.getHostname() != null) {
                    sb.append("|h:").append(sc.getHostname());
                }
                NonBlockingStatsDClient.this.tagString(sc.getTags(), sb);
                if (sc.getMessage() != null) {
                    sb.append("|m:").append(sc.getEscapedMessage());
                }
                NonBlockingStatsDClient.this.writeMessageTail(sb, this.tagsCardinality);
                return false;
            }
        });
        this.telemetry.incrServiceChecksSent(1);
    }

    private static boolean updateTagsWithEntityID(List<String> tags, String entityID) {
        if (entityID == null || entityID.trim().isEmpty()) {
            entityID = System.getenv(DD_ENTITY_ID_ENV_VAR);
        }
        if (entityID != null && !entityID.trim().isEmpty()) {
            String entityTag = "dd.internal.entity_id:" + entityID;
            return tags.add(entityTag);
        }
        return false;
    }

    @Override
    public void serviceCheck(ServiceCheck sc) {
        this.recordServiceCheckRun(sc);
    }

    @Override
    public void recordSetValue(String aspect, String val, String ... tags) {
        this.recordSetValue(aspect, val, this.clientTagsCardinality, tags);
    }

    @Override
    public void recordSetValue(String aspect, String val, TagsCardinality cardinality, String ... tags) {
        this.statsDProcessor.send(new AlphaNumericMessage(aspect, Message.Type.SET, val, cardinality, tags){

            protected void writeValue(StringBuilder builder) {
                builder.append(this.getValue());
            }

            @Override
            protected final boolean writeTo(StringBuilder builder, int capacity) {
                builder.append(NonBlockingStatsDClient.this.prefix).append(this.aspect).append(':');
                this.writeValue(builder);
                builder.append('|').append((Object)this.type);
                NonBlockingStatsDClient.this.tagString(this.tags, builder);
                NonBlockingStatsDClient.this.writeMessageTail(builder, this.tagsCardinality);
                return false;
            }
        });
    }

    protected boolean isInvalidSample(double sampleRate) {
        return sampleRate != 1.0 && ThreadLocalRandom.current().nextDouble() > sampleRate;
    }

    static boolean isOriginDetectionEnabled(boolean originDetectionEnabled) {
        if (!originDetectionEnabled) {
            return false;
        }
        String value = System.getenv(ORIGIN_DETECTION_ENABLED_ENV_VAR);
        String string = value = value != null ? value.trim() : null;
        if (value != null && !value.isEmpty()) {
            return !Arrays.asList("no", "false", "0", "n", "off").contains(value.toLowerCase());
        }
        return true;
    }

    private static String getContainerID(String containerID, boolean originDetectionEnabled) {
        if (containerID != null && !containerID.isEmpty()) {
            return containerID;
        }
        if (originDetectionEnabled) {
            CgroupReader reader = new CgroupReader();
            return reader.getContainerID();
        }
        return null;
    }

    private int getPacketSize(ClientChannel chan) {
        return this.maxPacketSizeBytes > 0 ? this.maxPacketSizeBytes : chan.getMaxPacketSizeBytes();
    }

    public void sendTelemetryMetric(String metric, Integer value) {
        this.telemetryStatsDProcessor.send(new TelemetryMessage(metric, value, this.telemetryTags));
    }

    void sendTelemetryMetric(String metric, Integer value, String tags) {
        StringBuilder tagsBuilder = new StringBuilder();
        tagsBuilder.setLength(0);
        tagsBuilder.append(this.telemetryTags);
        tagsBuilder.append(',');
        tagsBuilder.append(tags);
        this.telemetryStatsDProcessor.send(new TelemetryMessage(metric, value, tagsBuilder.toString()));
    }

    class TelemetryMessage
    extends NumericMessage<Integer> {
        private final String tagsString;

        protected TelemetryMessage(String metric, Integer value, String tags) {
            super(metric, Message.Type.COUNT, value, NonBlockingStatsDClient.this.clientTagsCardinality, null);
            this.tagsString = tags;
            this.done = true;
        }

        @Override
        public final boolean writeTo(StringBuilder builder, int capacity) {
            builder.append(this.aspect).append(':').append(this.value).append('|').append((Object)this.type).append(this.tagsString);
            NonBlockingStatsDClient.this.writeMessageTail(builder, this.tagsCardinality);
            return false;
        }
    }

    abstract class StatsDMessage<T extends Number>
    extends NumericMessage<T> {
        final double sampleRate;
        final long timestamp;
        final /* synthetic */ NonBlockingStatsDClient this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        protected StatsDMessage(String string, Message.Type timestamp, T t, double card, long l, TagsCardinality tagsCardinality, String[] stringArray) {
            void var5_5;
            void tags;
            void value;
            void aspect;
            this.this$0 = (NonBlockingStatsDClient)this$0;
            super((String)aspect, (Message.Type)type, value, (TagsCardinality)card, (String[])tags);
            this.sampleRate = var5_5;
            this.timestamp = timestamp;
        }

        @Override
        public final boolean writeTo(StringBuilder builder, int capacity) {
            builder.append(this.this$0.prefix).append(this.aspect).append(':');
            this.writeValue(builder);
            builder.append('|').append((Object)this.type);
            if (!Double.isNaN(this.sampleRate)) {
                builder.append('|').append('@').append(NonBlockingStatsDClient.format(SAMPLE_RATE_FORMATTER, this.sampleRate));
            }
            if (this.timestamp != 0L) {
                builder.append("|T").append(this.timestamp);
            }
            this.this$0.tagString(this.tags, builder);
            this.this$0.writeMessageTail(builder, this.tagsCardinality);
            return false;
        }

        @Override
        public boolean canAggregate() {
            return super.canAggregate() && this.timestamp == 0L;
        }

        protected abstract void writeValue(StringBuilder var1);
    }

    static enum Literal {
        SERVICE,
        ENV,
        VERSION;

        private static final String PREFIX = "dd";

        String envName() {
            return ("dd_" + this.toString()).toUpperCase();
        }

        String envVal() {
            return System.getenv(this.envName());
        }

        String tag() {
            return this.toString().toLowerCase();
        }
    }
}

