/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.ClientChannel;
import com.timgroup.statsd.NamedPipeSocketAddress;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

class NamedPipeClientChannel
implements ClientChannel {
    private final RandomAccessFile randomAccessFile;
    private final FileChannel fileChannel;
    private final String pipe;

    NamedPipeClientChannel(NamedPipeSocketAddress address) throws FileNotFoundException {
        this.pipe = address.getPipe();
        this.randomAccessFile = new RandomAccessFile(this.pipe, "rw");
        this.fileChannel = this.randomAccessFile.getChannel();
    }

    @Override
    public boolean isOpen() {
        return this.fileChannel.isOpen();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.fileChannel.write(src);
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    @Override
    public String getTransportType() {
        return "namedpipe";
    }

    public String toString() {
        return this.pipe;
    }

    @Override
    public int getMaxPacketSizeBytes() {
        return 8192;
    }
}

