/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.BufferPool;
import com.timgroup.statsd.StatsDClientErrorHandler;
import com.timgroup.statsd.Telemetry;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class StatsDSender
implements Runnable {
    private final Callable<SocketAddress> addressLookup;
    private final SocketAddress address;
    private final DatagramChannel clientChannel;
    private final StatsDClientErrorHandler handler;
    private final BufferPool pool;
    private final BlockingQueue<ByteBuffer> buffers;
    private static final int WAIT_SLEEP_MS = 10;
    private final ExecutorService executor;
    private static final int DEFAULT_WORKERS = 1;
    private final int workers;
    private final CountDownLatch endSignal;
    private volatile boolean shutdown;
    private final Telemetry telemetry;

    StatsDSender(Callable<SocketAddress> addressLookup, DatagramChannel clientChannel, StatsDClientErrorHandler handler, BufferPool pool, BlockingQueue<ByteBuffer> buffers, int workers, Telemetry telemetry) throws Exception {
        this.pool = pool;
        this.buffers = buffers;
        this.handler = handler;
        this.workers = workers;
        this.addressLookup = addressLookup;
        this.address = addressLookup.call();
        this.clientChannel = clientChannel;
        this.executor = Executors.newFixedThreadPool(workers, new ThreadFactory(){
            final ThreadFactory delegate = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable runnable) {
                Thread result = this.delegate.newThread(runnable);
                result.setName("StatsD-Sender-" + result.getName());
                result.setDaemon(true);
                return result;
            }
        });
        this.endSignal = new CountDownLatch(workers);
        this.telemetry = telemetry;
    }

    StatsDSender(Callable<SocketAddress> addressLookup, DatagramChannel clientChannel, StatsDClientErrorHandler handler, BufferPool pool, BlockingQueue<ByteBuffer> buffers, Telemetry telemetry) throws Exception {
        this(addressLookup, clientChannel, handler, pool, buffers, 1, telemetry);
    }

    StatsDSender(StatsDSender sender) throws Exception {
        this(sender.addressLookup, sender.clientChannel, sender.handler, sender.pool, sender.buffers, sender.workers, sender.telemetry);
    }

    StatsDSender(StatsDSender sender, BufferPool pool, BlockingQueue<ByteBuffer> buffers) throws Exception {
        this(sender.addressLookup, sender.clientChannel, sender.handler, pool, buffers, sender.workers, sender.telemetry);
    }

    @Override
    public void run() {
        for (int i = 0; i < this.workers; ++i) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    ByteBuffer buffer = null;
                    while (!StatsDSender.this.buffers.isEmpty() || !StatsDSender.this.shutdown) {
                        int sizeOfBuffer = 0;
                        try {
                            if (buffer != null) {
                                StatsDSender.this.pool.put(buffer);
                            }
                            if ((buffer = (ByteBuffer)StatsDSender.this.buffers.poll(10L, TimeUnit.MILLISECONDS)) == null) continue;
                            sizeOfBuffer = buffer.position();
                            buffer.flip();
                            int sentBytes = StatsDSender.this.clientChannel.send(buffer, StatsDSender.this.address);
                            buffer.clear();
                            if (sizeOfBuffer != sentBytes) {
                                throw new IOException(String.format("Could not send stat %s entirely to %s. Only sent %d out of %d bytes", buffer.toString(), StatsDSender.this.address.toString(), sentBytes, sizeOfBuffer));
                            }
                            StatsDSender.this.telemetry.incrBytesSent(sizeOfBuffer);
                            StatsDSender.this.telemetry.incrPacketSent(1);
                        }
                        catch (InterruptedException e) {
                            if (!StatsDSender.this.shutdown) continue;
                            StatsDSender.this.endSignal.countDown();
                            return;
                        }
                        catch (Exception e) {
                            StatsDSender.this.telemetry.incrBytesDropped(sizeOfBuffer);
                            StatsDSender.this.telemetry.incrPacketDropped(1);
                            StatsDSender.this.handler.handle(e);
                        }
                    }
                    StatsDSender.this.endSignal.countDown();
                }
            });
        }
        boolean done = false;
        while (!done) {
            try {
                this.endSignal.await();
                done = true;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    boolean isShutdown() {
        return this.shutdown;
    }

    void shutdown() {
        this.shutdown = true;
        this.executor.shutdown();
    }
}

