/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.InvalidMessageException;
import com.timgroup.statsd.Message;
import com.timgroup.statsd.StatsDClientErrorHandler;
import com.timgroup.statsd.StatsDProcessor;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class StatsDBlockingProcessor
extends StatsDProcessor {
    private final BlockingQueue<Message> messages;

    StatsDBlockingProcessor(int queueSize, StatsDClientErrorHandler handler, int maxPacketSizeBytes, int poolSize, int workers) throws Exception {
        super(queueSize, handler, maxPacketSizeBytes, poolSize, workers);
        this.messages = new ArrayBlockingQueue<Message>(queueSize);
    }

    @Override
    protected ProcessingTask createProcessingTask() {
        return new ProcessingTask();
    }

    StatsDBlockingProcessor(StatsDBlockingProcessor processor) throws Exception {
        super(processor);
        this.messages = new ArrayBlockingQueue<Message>(processor.getQcapacity());
    }

    @Override
    protected boolean send(Message message) {
        try {
            if (!this.shutdown) {
                this.messages.put(message);
                return true;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    private class ProcessingTask
    extends StatsDProcessor.ProcessingTask {
        private ProcessingTask() {
        }

        @Override
        public void run() {
            ByteBuffer sendBuffer;
            try {
                sendBuffer = StatsDBlockingProcessor.this.bufferPool.borrow();
            }
            catch (InterruptedException e) {
                StatsDBlockingProcessor.this.handler.handle(e);
                return;
            }
            while (!StatsDBlockingProcessor.this.shutdown || !StatsDBlockingProcessor.this.messages.isEmpty()) {
                try {
                    Message message = (Message)StatsDBlockingProcessor.this.messages.poll(10L, TimeUnit.MILLISECONDS);
                    if (message == null) continue;
                    this.builder.setLength(0);
                    message.writeTo(this.builder);
                    int lowerBoundSize = this.builder.length();
                    if (sendBuffer.capacity() < lowerBoundSize) {
                        throw new InvalidMessageException("Message longer than size of sendBuffer", this.builder.toString());
                    }
                    if (sendBuffer.remaining() < lowerBoundSize + 1) {
                        StatsDBlockingProcessor.this.outboundQueue.put(sendBuffer);
                        sendBuffer = StatsDBlockingProcessor.this.bufferPool.borrow();
                    }
                    sendBuffer.mark();
                    if (sendBuffer.position() > 0) {
                        sendBuffer.put((byte)10);
                    }
                    try {
                        this.writeBuilderToSendBuffer(sendBuffer);
                    }
                    catch (BufferOverflowException boe) {
                        StatsDBlockingProcessor.this.outboundQueue.put(sendBuffer);
                        sendBuffer = StatsDBlockingProcessor.this.bufferPool.borrow();
                        this.writeBuilderToSendBuffer(sendBuffer);
                    }
                    if (null != StatsDBlockingProcessor.this.messages.peek()) continue;
                    StatsDBlockingProcessor.this.outboundQueue.put(sendBuffer);
                    sendBuffer = StatsDBlockingProcessor.this.bufferPool.borrow();
                }
                catch (InterruptedException e) {
                    if (!StatsDBlockingProcessor.this.shutdown) continue;
                    StatsDBlockingProcessor.this.endSignal.countDown();
                    return;
                }
                catch (Exception e) {
                    StatsDBlockingProcessor.this.handler.handle(e);
                }
            }
            this.builder.setLength(0);
            this.builder.trimToSize();
            StatsDBlockingProcessor.this.endSignal.countDown();
        }
    }
}

